/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentOverviewMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentOverview
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentOverview> {
    private final Long pending;
    private final Long inProgress;
    private final Long succeeded;
    private final Long failed;
    private final Long skipped;
    private final Long ready;

    private DeploymentOverview(BuilderImpl builder) {
        this.pending = builder.pending;
        this.inProgress = builder.inProgress;
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.skipped = builder.skipped;
        this.ready = builder.ready;
    }

    public Long pending() {
        return this.pending;
    }

    public Long inProgress() {
        return this.inProgress;
    }

    public Long succeeded() {
        return this.succeeded;
    }

    public Long failed() {
        return this.failed;
    }

    public Long skipped() {
        return this.skipped;
    }

    public Long ready() {
        return this.ready;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pending() == null ? 0 : this.pending().hashCode());
        hashCode = 31 * hashCode + (this.inProgress() == null ? 0 : this.inProgress().hashCode());
        hashCode = 31 * hashCode + (this.succeeded() == null ? 0 : this.succeeded().hashCode());
        hashCode = 31 * hashCode + (this.failed() == null ? 0 : this.failed().hashCode());
        hashCode = 31 * hashCode + (this.skipped() == null ? 0 : this.skipped().hashCode());
        hashCode = 31 * hashCode + (this.ready() == null ? 0 : this.ready().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentOverview)) {
            return false;
        }
        DeploymentOverview other = (DeploymentOverview)obj;
        if (other.pending() == null ^ this.pending() == null) {
            return false;
        }
        if (other.pending() != null && !other.pending().equals(this.pending())) {
            return false;
        }
        if (other.inProgress() == null ^ this.inProgress() == null) {
            return false;
        }
        if (other.inProgress() != null && !other.inProgress().equals(this.inProgress())) {
            return false;
        }
        if (other.succeeded() == null ^ this.succeeded() == null) {
            return false;
        }
        if (other.succeeded() != null && !other.succeeded().equals(this.succeeded())) {
            return false;
        }
        if (other.failed() == null ^ this.failed() == null) {
            return false;
        }
        if (other.failed() != null && !other.failed().equals(this.failed())) {
            return false;
        }
        if (other.skipped() == null ^ this.skipped() == null) {
            return false;
        }
        if (other.skipped() != null && !other.skipped().equals(this.skipped())) {
            return false;
        }
        if (other.ready() == null ^ this.ready() == null) {
            return false;
        }
        return other.ready() == null || other.ready().equals(this.ready());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pending() != null) {
            sb.append("Pending: ").append(this.pending()).append(",");
        }
        if (this.inProgress() != null) {
            sb.append("InProgress: ").append(this.inProgress()).append(",");
        }
        if (this.succeeded() != null) {
            sb.append("Succeeded: ").append(this.succeeded()).append(",");
        }
        if (this.failed() != null) {
            sb.append("Failed: ").append(this.failed()).append(",");
        }
        if (this.skipped() != null) {
            sb.append("Skipped: ").append(this.skipped()).append(",");
        }
        if (this.ready() != null) {
            sb.append("Ready: ").append(this.ready()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pending": {
                return Optional.of(clazz.cast(this.pending()));
            }
            case "InProgress": {
                return Optional.of(clazz.cast(this.inProgress()));
            }
            case "Succeeded": {
                return Optional.of(clazz.cast(this.succeeded()));
            }
            case "Failed": {
                return Optional.of(clazz.cast(this.failed()));
            }
            case "Skipped": {
                return Optional.of(clazz.cast(this.skipped()));
            }
            case "Ready": {
                return Optional.of(clazz.cast(this.ready()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long pending;
        private Long inProgress;
        private Long succeeded;
        private Long failed;
        private Long skipped;
        private Long ready;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentOverview model) {
            this.pending(model.pending);
            this.inProgress(model.inProgress);
            this.succeeded(model.succeeded);
            this.failed(model.failed);
            this.skipped(model.skipped);
            this.ready(model.ready);
        }

        public final Long getPending() {
            return this.pending;
        }

        @Override
        public final Builder pending(Long pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Long pending) {
            this.pending = pending;
        }

        public final Long getInProgress() {
            return this.inProgress;
        }

        @Override
        public final Builder inProgress(Long inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final void setInProgress(Long inProgress) {
            this.inProgress = inProgress;
        }

        public final Long getSucceeded() {
            return this.succeeded;
        }

        @Override
        public final Builder succeeded(Long succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final void setSucceeded(Long succeeded) {
            this.succeeded = succeeded;
        }

        public final Long getFailed() {
            return this.failed;
        }

        @Override
        public final Builder failed(Long failed) {
            this.failed = failed;
            return this;
        }

        public final void setFailed(Long failed) {
            this.failed = failed;
        }

        public final Long getSkipped() {
            return this.skipped;
        }

        @Override
        public final Builder skipped(Long skipped) {
            this.skipped = skipped;
            return this;
        }

        public final void setSkipped(Long skipped) {
            this.skipped = skipped;
        }

        public final Long getReady() {
            return this.ready;
        }

        @Override
        public final Builder ready(Long ready) {
            this.ready = ready;
            return this;
        }

        public final void setReady(Long ready) {
            this.ready = ready;
        }

        public DeploymentOverview build() {
            return new DeploymentOverview(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentOverview> {
        public Builder pending(Long var1);

        public Builder inProgress(Long var1);

        public Builder succeeded(Long var1);

        public Builder failed(Long var1);

        public Builder skipped(Long var1);

        public Builder ready(Long var1);
    }
}

