/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
    private final List<DeploymentGroupInfo> deploymentGroupsInfo;
    private final String errorMessage;

    private BatchGetDeploymentGroupsResponse(BuilderImpl builder) {
        this.deploymentGroupsInfo = builder.deploymentGroupsInfo;
        this.errorMessage = builder.errorMessage;
    }

    public List<DeploymentGroupInfo> deploymentGroupsInfo() {
        return this.deploymentGroupsInfo;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentGroupsInfo() == null ? 0 : this.deploymentGroupsInfo().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsResponse)) {
            return false;
        }
        BatchGetDeploymentGroupsResponse other = (BatchGetDeploymentGroupsResponse)((Object)obj);
        if (other.deploymentGroupsInfo() == null ^ this.deploymentGroupsInfo() == null) {
            return false;
        }
        if (other.deploymentGroupsInfo() != null && !other.deploymentGroupsInfo().equals(this.deploymentGroupsInfo())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        return other.errorMessage() == null || other.errorMessage().equals(this.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentGroupsInfo() != null) {
            sb.append("DeploymentGroupsInfo: ").append(this.deploymentGroupsInfo()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentGroupsInfo": {
                return Optional.of(clazz.cast(this.deploymentGroupsInfo()));
            }
            case "errorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DeploymentGroupInfo> deploymentGroupsInfo;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsResponse model) {
            this.deploymentGroupsInfo(model.deploymentGroupsInfo);
            this.errorMessage(model.errorMessage);
        }

        public final Collection<DeploymentGroupInfo.Builder> getDeploymentGroupsInfo() {
            return this.deploymentGroupsInfo != null ? (Collection)this.deploymentGroupsInfo.stream().map(DeploymentGroupInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(DeploymentGroupInfo ... deploymentGroupsInfo) {
            this.deploymentGroupsInfo(Arrays.asList(deploymentGroupsInfo));
            return this;
        }

        public final void setDeploymentGroupsInfo(Collection<DeploymentGroupInfo.BuilderImpl> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copyFromBuilder(deploymentGroupsInfo);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public BatchGetDeploymentGroupsResponse build() {
            return new BatchGetDeploymentGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
        public Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> var1);

        public Builder deploymentGroupsInfo(DeploymentGroupInfo ... var1);

        public Builder errorMessage(String var1);
    }
}

