/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.Alarm;
import software.amazon.awssdk.services.codedeploy.model.AlarmListCopier;
import software.amazon.awssdk.services.codedeploy.transform.AlarmConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AlarmConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, AlarmConfiguration> {
    private final Boolean enabled;
    private final Boolean ignorePollAlarmFailure;
    private final List<Alarm> alarms;

    private AlarmConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.ignorePollAlarmFailure = builder.ignorePollAlarmFailure;
        this.alarms = builder.alarms;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean ignorePollAlarmFailure() {
        return this.ignorePollAlarmFailure;
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.ignorePollAlarmFailure() == null ? 0 : this.ignorePollAlarmFailure().hashCode());
        hashCode = 31 * hashCode + (this.alarms() == null ? 0 : this.alarms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmConfiguration)) {
            return false;
        }
        AlarmConfiguration other = (AlarmConfiguration)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.ignorePollAlarmFailure() == null ^ this.ignorePollAlarmFailure() == null) {
            return false;
        }
        if (other.ignorePollAlarmFailure() != null && !other.ignorePollAlarmFailure().equals(this.ignorePollAlarmFailure())) {
            return false;
        }
        if (other.alarms() == null ^ this.alarms() == null) {
            return false;
        }
        return other.alarms() == null || other.alarms().equals(this.alarms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.ignorePollAlarmFailure() != null) {
            sb.append("IgnorePollAlarmFailure: ").append(this.ignorePollAlarmFailure()).append(",");
        }
        if (this.alarms() != null) {
            sb.append("Alarms: ").append(this.alarms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlarmConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean ignorePollAlarmFailure;
        private List<Alarm> alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmConfiguration model) {
            this.setEnabled(model.enabled);
            this.setIgnorePollAlarmFailure(model.ignorePollAlarmFailure);
            this.setAlarms(model.alarms);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getIgnorePollAlarmFailure() {
            return this.ignorePollAlarmFailure;
        }

        @Override
        public final Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
            return this;
        }

        public final void setIgnorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
        }

        public final Collection<Alarm> getAlarms() {
            return this.alarms;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
        }

        public AlarmConfiguration build() {
            return new AlarmConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AlarmConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder ignorePollAlarmFailure(Boolean var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);
    }
}

