/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameListCopier;
import software.amazon.awssdk.services.codedeploy.model.Tag;
import software.amazon.awssdk.services.codedeploy.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddTagsToOnPremisesInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddTagsToOnPremisesInstancesRequest> {
    private final List<Tag> tags;
    private final List<String> instanceNames;

    private AddTagsToOnPremisesInstancesRequest(BuilderImpl builder) {
        this.tags = builder.tags;
        this.instanceNames = builder.instanceNames;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.instanceNames() == null ? 0 : this.instanceNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToOnPremisesInstancesRequest)) {
            return false;
        }
        AddTagsToOnPremisesInstancesRequest other = (AddTagsToOnPremisesInstancesRequest)((Object)obj);
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        return other.instanceNames() == null || other.instanceNames().equals(this.instanceNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.instanceNames() != null) {
            sb.append("InstanceNames: ").append(this.instanceNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Tag> tags;
        private List<String> instanceNames;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsToOnPremisesInstancesRequest model) {
            this.setTags(model.tags);
            this.setInstanceNames(model.instanceNames);
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        public AddTagsToOnPremisesInstancesRequest build() {
            return new AddTagsToOnPremisesInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddTagsToOnPremisesInstancesRequest> {
        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);
    }
}

