/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfig;

@SdkInternalApi
public class TriggerConfigMarshaller {
    private static final MarshallingInfo<String> TRIGGERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggerName").build();
    private static final MarshallingInfo<String> TRIGGERTARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggerTargetArn").build();
    private static final MarshallingInfo<List> TRIGGEREVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggerEvents").build();
    private static final TriggerConfigMarshaller INSTANCE = new TriggerConfigMarshaller();

    public static TriggerConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TriggerConfig triggerConfig, ProtocolMarshaller protocolMarshaller) {
        if (triggerConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)triggerConfig.triggerName(), TRIGGERNAME_BINDING);
            protocolMarshaller.marshall((Object)triggerConfig.triggerTargetArn(), TRIGGERTARGETARN_BINDING);
            protocolMarshaller.marshall(triggerConfig.triggerEvents(), TRIGGEREVENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

