/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;

@SdkInternalApi
public class RevisionLocationMarshaller {
    private static final MarshallingInfo<String> REVISIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionType").build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").build();
    private static final MarshallingInfo<StructuredPojo> GITHUBLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gitHubLocation").build();
    private static final RevisionLocationMarshaller INSTANCE = new RevisionLocationMarshaller();

    public static RevisionLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RevisionLocation revisionLocation, ProtocolMarshaller protocolMarshaller) {
        if (revisionLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)revisionLocation.revisionType(), REVISIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)revisionLocation.s3Location(), S3LOCATION_BINDING);
            protocolMarshaller.marshall((Object)revisionLocation.gitHubLocation(), GITHUBLOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

