/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatus;
import software.amazon.awssdk.services.codedeploy.model.InstanceType;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventListCopier;
import software.amazon.awssdk.services.codedeploy.transform.InstanceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceSummary> {
    private final String deploymentId;
    private final String instanceId;
    private final String status;
    private final Instant lastUpdatedAt;
    private final List<LifecycleEvent> lifecycleEvents;
    private final String instanceType;

    private InstanceSummary(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.instanceType = builder.instanceType;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String status() {
        return this.status;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public List<LifecycleEvent> lifecycleEvents() {
        return this.lifecycleEvents;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentId() == null ? 0 : this.deploymentId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedAt() == null ? 0 : this.lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.lifecycleEvents() == null ? 0 : this.lifecycleEvents().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary)obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.lifecycleEvents() == null ^ this.lifecycleEvents() == null) {
            return false;
        }
        if (other.lifecycleEvents() != null && !other.lifecycleEvents().equals(this.lifecycleEvents())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        return other.instanceType() == null || other.instanceType().equals(this.instanceType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.lastUpdatedAt()).append(",");
        }
        if (this.lifecycleEvents() != null) {
            sb.append("LifecycleEvents: ").append(this.lifecycleEvents()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String instanceId;
        private String status;
        private Instant lastUpdatedAt;
        private List<LifecycleEvent> lifecycleEvents;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            this.setDeploymentId(model.deploymentId);
            this.setInstanceId(model.instanceId);
            this.setStatus(model.status);
            this.setLastUpdatedAt(model.lastUpdatedAt);
            this.setLifecycleEvents(model.lifecycleEvents);
            this.setInstanceType(model.instanceType);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Collection<LifecycleEvent> getLifecycleEvents() {
            return this.lifecycleEvents;
        }

        @Override
        public final Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(LifecycleEvent ... lifecycleEvents) {
            this.lifecycleEvents(Arrays.asList(lifecycleEvents));
            return this;
        }

        public final void setLifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public InstanceSummary build() {
            return new InstanceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceSummary> {
        public Builder deploymentId(String var1);

        public Builder instanceId(String var1);

        public Builder status(String var1);

        public Builder status(InstanceStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleEvents(Collection<LifecycleEvent> var1);

        public Builder lifecycleEvents(LifecycleEvent ... var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);
    }
}

