/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentReadyOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentReadyOption
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentReadyOption> {
    private final String actionOnTimeout;
    private final Integer waitTimeInMinutes;

    private DeploymentReadyOption(BuilderImpl builder) {
        this.actionOnTimeout = builder.actionOnTimeout;
        this.waitTimeInMinutes = builder.waitTimeInMinutes;
    }

    public String actionOnTimeout() {
        return this.actionOnTimeout;
    }

    public Integer waitTimeInMinutes() {
        return this.waitTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionOnTimeout() == null ? 0 : this.actionOnTimeout().hashCode());
        hashCode = 31 * hashCode + (this.waitTimeInMinutes() == null ? 0 : this.waitTimeInMinutes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentReadyOption)) {
            return false;
        }
        DeploymentReadyOption other = (DeploymentReadyOption)obj;
        if (other.actionOnTimeout() == null ^ this.actionOnTimeout() == null) {
            return false;
        }
        if (other.actionOnTimeout() != null && !other.actionOnTimeout().equals(this.actionOnTimeout())) {
            return false;
        }
        if (other.waitTimeInMinutes() == null ^ this.waitTimeInMinutes() == null) {
            return false;
        }
        return other.waitTimeInMinutes() == null || other.waitTimeInMinutes().equals(this.waitTimeInMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actionOnTimeout() != null) {
            sb.append("ActionOnTimeout: ").append(this.actionOnTimeout()).append(",");
        }
        if (this.waitTimeInMinutes() != null) {
            sb.append("WaitTimeInMinutes: ").append(this.waitTimeInMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentReadyOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String actionOnTimeout;
        private Integer waitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentReadyOption model) {
            this.setActionOnTimeout(model.actionOnTimeout);
            this.setWaitTimeInMinutes(model.waitTimeInMinutes);
        }

        public final String getActionOnTimeout() {
            return this.actionOnTimeout;
        }

        @Override
        public final Builder actionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
            return this;
        }

        @Override
        public final Builder actionOnTimeout(DeploymentReadyAction actionOnTimeout) {
            this.actionOnTimeout(actionOnTimeout.toString());
            return this;
        }

        public final void setActionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
        }

        public final Integer getWaitTimeInMinutes() {
            return this.waitTimeInMinutes;
        }

        @Override
        public final Builder waitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
            return this;
        }

        public final void setWaitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
        }

        public DeploymentReadyOption build() {
            return new DeploymentReadyOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentReadyOption> {
        public Builder actionOnTimeout(String var1);

        public Builder actionOnTimeout(DeploymentReadyAction var1);

        public Builder waitTimeInMinutes(Integer var1);
    }
}

