/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfo;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetOnPremisesInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
    private final List<InstanceInfo> instanceInfos;

    private BatchGetOnPremisesInstancesResponse(BuilderImpl builder) {
        this.instanceInfos = builder.instanceInfos;
    }

    public List<InstanceInfo> instanceInfos() {
        return this.instanceInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceInfos() == null ? 0 : this.instanceInfos().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesResponse)) {
            return false;
        }
        BatchGetOnPremisesInstancesResponse other = (BatchGetOnPremisesInstancesResponse)((Object)obj);
        if (other.instanceInfos() == null ^ this.instanceInfos() == null) {
            return false;
        }
        return other.instanceInfos() == null || other.instanceInfos().equals(this.instanceInfos());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceInfos() != null) {
            sb.append("InstanceInfos: ").append(this.instanceInfos()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceInfo> instanceInfos;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesResponse model) {
            this.setInstanceInfos(model.instanceInfos);
        }

        public final Collection<InstanceInfo> getInstanceInfos() {
            return this.instanceInfos;
        }

        @Override
        public final Builder instanceInfos(Collection<InstanceInfo> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copy(instanceInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(InstanceInfo ... instanceInfos) {
            this.instanceInfos(Arrays.asList(instanceInfos));
            return this;
        }

        public final void setInstanceInfos(Collection<InstanceInfo> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copy(instanceInfos);
        }

        public BatchGetOnPremisesInstancesResponse build() {
            return new BatchGetOnPremisesInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
        public Builder instanceInfos(Collection<InstanceInfo> var1);

        public Builder instanceInfos(InstanceInfo ... var1);
    }
}

