/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.AutoScalingGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingGroup> {
    private final String name;
    private final String hook;

    private AutoScalingGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.hook = builder.hook;
    }

    public String name() {
        return this.name;
    }

    public String hook() {
        return this.hook;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.hook() == null ? 0 : this.hook().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.hook() == null ^ this.hook() == null) {
            return false;
        }
        return other.hook() == null || other.hook().equals(this.hook());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.hook() != null) {
            sb.append("Hook: ").append(this.hook()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String hook;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            this.setName(model.name);
            this.setHook(model.hook);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getHook() {
            return this.hook;
        }

        @Override
        public final Builder hook(String hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(String hook) {
            this.hook = hook;
        }

        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingGroup> {
        public Builder name(String var1);

        public Builder hook(String var1);
    }
}

