/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codedeploy.model.S3Location;

public class S3LocationUnmarshaller
implements Unmarshaller<S3Location, JsonUnmarshallerContext> {
    private static S3LocationUnmarshaller INSTANCE;

    public S3Location unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Location.Builder s3LocationBuilder = S3Location.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucket", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.bucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("bundleType", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.bundleType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eTag", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.eTag((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3Location)s3LocationBuilder.build();
    }

    public static S3LocationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3LocationUnmarshaller();
        }
        return INSTANCE;
    }
}

