/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatus;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatusListCopier;
import software.amazon.awssdk.services.codedeploy.model.InstanceType;
import software.amazon.awssdk.services.codedeploy.model.InstanceTypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListDeploymentInstancesRequest> {
    private final String deploymentId;
    private final String nextToken;
    private final List<String> instanceStatusFilter;
    private final List<String> instanceTypeFilter;

    private ListDeploymentInstancesRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.nextToken = builder.nextToken;
        this.instanceStatusFilter = builder.instanceStatusFilter;
        this.instanceTypeFilter = builder.instanceTypeFilter;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> instanceStatusFilter() {
        return this.instanceStatusFilter;
    }

    public List<String> instanceTypeFilter() {
        return this.instanceTypeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentId() == null ? 0 : this.deploymentId().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.instanceStatusFilter() == null ? 0 : this.instanceStatusFilter().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypeFilter() == null ? 0 : this.instanceTypeFilter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesRequest)) {
            return false;
        }
        ListDeploymentInstancesRequest other = (ListDeploymentInstancesRequest)((Object)obj);
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.instanceStatusFilter() == null ^ this.instanceStatusFilter() == null) {
            return false;
        }
        if (other.instanceStatusFilter() != null && !other.instanceStatusFilter().equals(this.instanceStatusFilter())) {
            return false;
        }
        if (other.instanceTypeFilter() == null ^ this.instanceTypeFilter() == null) {
            return false;
        }
        return other.instanceTypeFilter() == null || other.instanceTypeFilter().equals(this.instanceTypeFilter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.instanceStatusFilter() != null) {
            sb.append("InstanceStatusFilter: ").append(this.instanceStatusFilter()).append(",");
        }
        if (this.instanceTypeFilter() != null) {
            sb.append("InstanceTypeFilter: ").append(this.instanceTypeFilter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String nextToken;
        private List<String> instanceStatusFilter;
        private List<String> instanceTypeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentInstancesRequest model) {
            this.setDeploymentId(model.deploymentId);
            this.setNextToken(model.nextToken);
            this.setInstanceStatusFilter(model.instanceStatusFilter);
            this.setInstanceTypeFilter(model.instanceTypeFilter);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getInstanceStatusFilter() {
            return this.instanceStatusFilter;
        }

        @Override
        public final Builder instanceStatusFilter(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusFilter(String ... instanceStatusFilter) {
            this.instanceStatusFilter(Arrays.asList(instanceStatusFilter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusFilter(InstanceStatus ... instanceStatusFilter) {
            this.instanceStatusFilter(Arrays.asList(instanceStatusFilter).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceStatusFilter(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
        }

        @SafeVarargs
        public final void setInstanceStatusFilter(String ... instanceStatusFilter) {
            this.instanceStatusFilter(Arrays.asList(instanceStatusFilter));
        }

        @SafeVarargs
        public final void setInstanceStatusFilter(InstanceStatus ... instanceStatusFilter) {
            this.instanceStatusFilter(Arrays.asList(instanceStatusFilter).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final Collection<String> getInstanceTypeFilter() {
            return this.instanceTypeFilter;
        }

        @Override
        public final Builder instanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(String ... instanceTypeFilter) {
            this.instanceTypeFilter(Arrays.asList(instanceTypeFilter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(InstanceType ... instanceTypeFilter) {
            this.instanceTypeFilter(Arrays.asList(instanceTypeFilter).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
        }

        @SafeVarargs
        public final void setInstanceTypeFilter(String ... instanceTypeFilter) {
            this.instanceTypeFilter(Arrays.asList(instanceTypeFilter));
        }

        @SafeVarargs
        public final void setInstanceTypeFilter(InstanceType ... instanceTypeFilter) {
            this.instanceTypeFilter(Arrays.asList(instanceTypeFilter).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public ListDeploymentInstancesRequest build() {
            return new ListDeploymentInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeploymentInstancesRequest> {
        public Builder deploymentId(String var1);

        public Builder nextToken(String var1);

        public Builder instanceStatusFilter(Collection<String> var1);

        public Builder instanceStatusFilter(String ... var1);

        public Builder instanceStatusFilter(InstanceStatus ... var1);

        public Builder instanceTypeFilter(Collection<String> var1);

        public Builder instanceTypeFilter(String ... var1);

        public Builder instanceTypeFilter(InstanceType ... var1);
    }
}

