/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateApplicationRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationName").isBinary(false).build();
    private static final MarshallingInfo<String> COMPUTEPLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computePlatform").isBinary(false).build();
    private static final CreateApplicationRequestModelMarshaller INSTANCE = new CreateApplicationRequestModelMarshaller();

    private CreateApplicationRequestModelMarshaller() {
    }

    public static CreateApplicationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateApplicationRequest createApplicationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createApplicationRequest), (String)"createApplicationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createApplicationRequest.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)createApplicationRequest.computePlatformAsString(), COMPUTEPLATFORM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

