/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLifecycleEventHookExecutionStatusRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, PutLifecycleEventHookExecutionStatusRequest> {
    private final String deploymentId;
    private final String lifecycleEventHookExecutionId;
    private final String status;

    private PutLifecycleEventHookExecutionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.lifecycleEventHookExecutionId = builder.lifecycleEventHookExecutionId;
        this.status = builder.status;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String lifecycleEventHookExecutionId() {
        return this.lifecycleEventHookExecutionId;
    }

    public LifecycleEventStatus status() {
        return LifecycleEventStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEventHookExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleEventHookExecutionStatusRequest)) {
            return false;
        }
        PutLifecycleEventHookExecutionStatusRequest other = (PutLifecycleEventHookExecutionStatusRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.lifecycleEventHookExecutionId(), other.lifecycleEventHookExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutLifecycleEventHookExecutionStatusRequest").add("DeploymentId", (Object)this.deploymentId()).add("LifecycleEventHookExecutionId", (Object)this.lifecycleEventHookExecutionId()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "lifecycleEventHookExecutionId": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEventHookExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String deploymentId;
        private String lifecycleEventHookExecutionId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleEventHookExecutionStatusRequest model) {
            super(model);
            this.deploymentId(model.deploymentId);
            this.lifecycleEventHookExecutionId(model.lifecycleEventHookExecutionId);
            this.status(model.status);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getLifecycleEventHookExecutionId() {
            return this.lifecycleEventHookExecutionId;
        }

        @Override
        public final Builder lifecycleEventHookExecutionId(String lifecycleEventHookExecutionId) {
            this.lifecycleEventHookExecutionId = lifecycleEventHookExecutionId;
            return this;
        }

        public final void setLifecycleEventHookExecutionId(String lifecycleEventHookExecutionId) {
            this.lifecycleEventHookExecutionId = lifecycleEventHookExecutionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecycleEventStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLifecycleEventHookExecutionStatusRequest build() {
            return new PutLifecycleEventHookExecutionStatusRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, PutLifecycleEventHookExecutionStatusRequest> {
        public Builder deploymentId(String var1);

        public Builder lifecycleEventHookExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(LifecycleEventStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

