/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.TargetInstances;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final RevisionLocation revision;
    private final String deploymentConfigName;
    private final String description;
    private final Boolean ignoreApplicationStopFailures;
    private final TargetInstances targetInstances;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final Boolean updateOutdatedInstancesOnly;
    private final String fileExistsBehavior;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.revision = builder.revision;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.description = builder.description;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.targetInstances = builder.targetInstances;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public String description() {
        return this.description;
    }

    public Boolean ignoreApplicationStopFailures() {
        return this.ignoreApplicationStopFailures;
    }

    public TargetInstances targetInstances() {
        return this.targetInstances;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public Boolean updateOutdatedInstancesOnly() {
        return this.updateOutdatedInstancesOnly;
    }

    public FileExistsBehavior fileExistsBehavior() {
        return FileExistsBehavior.fromValue(this.fileExistsBehavior);
    }

    public String fileExistsBehaviorAsString() {
        return this.fileExistsBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreApplicationStopFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateOutdatedInstancesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileExistsBehaviorAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ignoreApplicationStopFailures(), other.ignoreApplicationStopFailures()) && Objects.equals(this.targetInstances(), other.targetInstances()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration()) && Objects.equals(this.updateOutdatedInstancesOnly(), other.updateOutdatedInstancesOnly()) && Objects.equals(this.fileExistsBehaviorAsString(), other.fileExistsBehaviorAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupName", (Object)this.deploymentGroupName()).add("Revision", (Object)this.revision()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("Description", (Object)this.description()).add("IgnoreApplicationStopFailures", (Object)this.ignoreApplicationStopFailures()).add("TargetInstances", (Object)this.targetInstances()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).add("UpdateOutdatedInstancesOnly", (Object)this.updateOutdatedInstancesOnly()).add("FileExistsBehavior", (Object)this.fileExistsBehaviorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupName()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ignoreApplicationStopFailures": {
                return Optional.ofNullable(clazz.cast(this.ignoreApplicationStopFailures()));
            }
            case "targetInstances": {
                return Optional.ofNullable(clazz.cast(this.targetInstances()));
            }
            case "autoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "updateOutdatedInstancesOnly": {
                return Optional.ofNullable(clazz.cast(this.updateOutdatedInstancesOnly()));
            }
            case "fileExistsBehavior": {
                return Optional.ofNullable(clazz.cast(this.fileExistsBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private RevisionLocation revision;
        private String deploymentConfigName;
        private String description;
        private Boolean ignoreApplicationStopFailures;
        private TargetInstances targetInstances;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private Boolean updateOutdatedInstancesOnly;
        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.revision(model.revision);
            this.deploymentConfigName(model.deploymentConfigName);
            this.description(model.description);
            this.ignoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            this.targetInstances(model.targetInstances);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.updateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            this.fileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return this.ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        public final TargetInstances.Builder getTargetInstances() {
            return this.targetInstances != null ? this.targetInstances.toBuilder() : null;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final void setTargetInstances(TargetInstances.BuilderImpl targetInstances) {
            this.targetInstances = targetInstances != null ? targetInstances.build() : null;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return this.updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        public final String getFileExistsBehavior() {
            return this.fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
            return this;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation(revision)).build());
        }

        public Builder deploymentConfigName(String var1);

        public Builder description(String var1);

        public Builder ignoreApplicationStopFailures(Boolean var1);

        public Builder targetInstances(TargetInstances var1);

        default public Builder targetInstances(Consumer<TargetInstances.Builder> targetInstances) {
            return this.targetInstances((TargetInstances)((TargetInstances.Builder)TargetInstances.builder().applyMutation(targetInstances)).build());
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfiguration)((AutoRollbackConfiguration.Builder)AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration)).build());
        }

        public Builder updateOutdatedInstancesOnly(Boolean var1);

        public Builder fileExistsBehavior(String var1);

        public Builder fileExistsBehavior(FileExistsBehavior var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

