/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LoadBalancerInfoMarshaller {
    private static final MarshallingInfo<List> ELBINFOLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elbInfoList").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETGROUPINFOLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetGroupInfoList").isBinary(false).build();
    private static final LoadBalancerInfoMarshaller INSTANCE = new LoadBalancerInfoMarshaller();

    private LoadBalancerInfoMarshaller() {
    }

    public static LoadBalancerInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LoadBalancerInfo loadBalancerInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)loadBalancerInfo, (String)"loadBalancerInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(loadBalancerInfo.elbInfoList(), ELBINFOLIST_BINDING);
            protocolMarshaller.marshall(loadBalancerInfo.targetGroupInfoList(), TARGETGROUPINFOLIST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

