/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatus;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatusListCopier;
import software.amazon.awssdk.services.codedeploy.model.InstanceType;
import software.amazon.awssdk.services.codedeploy.model.InstanceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentInstancesRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, ListDeploymentInstancesRequest> {
    private final String deploymentId;
    private final String nextToken;
    private final List<String> instanceStatusFilter;
    private final List<String> instanceTypeFilter;

    private ListDeploymentInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.nextToken = builder.nextToken;
        this.instanceStatusFilter = builder.instanceStatusFilter;
        this.instanceTypeFilter = builder.instanceTypeFilter;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<InstanceStatus> instanceStatusFilter() {
        return TypeConverter.convert(this.instanceStatusFilter, InstanceStatus::fromValue);
    }

    public List<String> instanceStatusFilterAsStrings() {
        return this.instanceStatusFilter;
    }

    public List<InstanceType> instanceTypeFilter() {
        return TypeConverter.convert(this.instanceTypeFilter, InstanceType::fromValue);
    }

    public List<String> instanceTypeFilterAsStrings() {
        return this.instanceTypeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatusFilterAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeFilterAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesRequest)) {
            return false;
        }
        ListDeploymentInstancesRequest other = (ListDeploymentInstancesRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.instanceStatusFilterAsStrings(), other.instanceStatusFilterAsStrings()) && Objects.equals(this.instanceTypeFilterAsStrings(), other.instanceTypeFilterAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentInstancesRequest").add("DeploymentId", (Object)this.deploymentId()).add("NextToken", (Object)this.nextToken()).add("InstanceStatusFilter", this.instanceStatusFilterAsStrings()).add("InstanceTypeFilter", this.instanceTypeFilterAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "instanceStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.instanceStatusFilterAsStrings()));
            }
            case "instanceTypeFilter": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeFilterAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String deploymentId;
        private String nextToken;
        private List<String> instanceStatusFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceTypeFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentInstancesRequest model) {
            super(model);
            this.deploymentId(model.deploymentId);
            this.nextToken(model.nextToken);
            this.instanceStatusFilterWithStrings(model.instanceStatusFilter);
            this.instanceTypeFilterWithStrings(model.instanceTypeFilter);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getInstanceStatusFilter() {
            return this.instanceStatusFilter;
        }

        @Override
        public final Builder instanceStatusFilterWithStrings(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusFilterWithStrings(String ... instanceStatusFilter) {
            this.instanceStatusFilterWithStrings(Arrays.asList(instanceStatusFilter));
            return this;
        }

        @Override
        public final Builder instanceStatusFilter(Collection<InstanceStatus> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copyEnumToString(instanceStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusFilter(InstanceStatus ... instanceStatusFilter) {
            this.instanceStatusFilter(Arrays.asList(instanceStatusFilter));
            return this;
        }

        public final void setInstanceStatusFilter(Collection<String> instanceStatusFilter) {
            this.instanceStatusFilter = InstanceStatusListCopier.copy(instanceStatusFilter);
        }

        public final Collection<String> getInstanceTypeFilter() {
            return this.instanceTypeFilter;
        }

        @Override
        public final Builder instanceTypeFilterWithStrings(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilterWithStrings(String ... instanceTypeFilter) {
            this.instanceTypeFilterWithStrings(Arrays.asList(instanceTypeFilter));
            return this;
        }

        @Override
        public final Builder instanceTypeFilter(Collection<InstanceType> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copyEnumToString(instanceTypeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(InstanceType ... instanceTypeFilter) {
            this.instanceTypeFilter(Arrays.asList(instanceTypeFilter));
            return this;
        }

        public final void setInstanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = InstanceTypeListCopier.copy(instanceTypeFilter);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeploymentInstancesRequest build() {
            return new ListDeploymentInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, ListDeploymentInstancesRequest> {
        public Builder deploymentId(String var1);

        public Builder nextToken(String var1);

        public Builder instanceStatusFilterWithStrings(Collection<String> var1);

        public Builder instanceStatusFilterWithStrings(String ... var1);

        public Builder instanceStatusFilter(Collection<InstanceStatus> var1);

        public Builder instanceStatusFilter(InstanceStatus ... var1);

        public Builder instanceTypeFilterWithStrings(Collection<String> var1);

        public Builder instanceTypeFilterWithStrings(String ... var1);

        public Builder instanceTypeFilter(Collection<InstanceType> var1);

        public Builder instanceTypeFilter(InstanceType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

