/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.ApplicationInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationInfo> {
    private final String applicationId;
    private final String applicationName;
    private final Instant createTime;
    private final Boolean linkedToGitHub;
    private final String gitHubAccountName;

    private ApplicationInfo(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationName = builder.applicationName;
        this.createTime = builder.createTime;
        this.linkedToGitHub = builder.linkedToGitHub;
        this.gitHubAccountName = builder.gitHubAccountName;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Boolean linkedToGitHub() {
        return this.linkedToGitHub;
    }

    public String gitHubAccountName() {
        return this.gitHubAccountName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedToGitHub());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitHubAccountName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.linkedToGitHub(), other.linkedToGitHub()) && Objects.equals(this.gitHubAccountName(), other.gitHubAccountName());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationInfo").add("ApplicationId", (Object)this.applicationId()).add("ApplicationName", (Object)this.applicationName()).add("CreateTime", (Object)this.createTime()).add("LinkedToGitHub", (Object)this.linkedToGitHub()).add("GitHubAccountName", (Object)this.gitHubAccountName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "linkedToGitHub": {
                return Optional.ofNullable(clazz.cast(this.linkedToGitHub()));
            }
            case "gitHubAccountName": {
                return Optional.ofNullable(clazz.cast(this.gitHubAccountName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationName;
        private Instant createTime;
        private Boolean linkedToGitHub;
        private String gitHubAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            this.applicationId(model.applicationId);
            this.applicationName(model.applicationName);
            this.createTime(model.createTime);
            this.linkedToGitHub(model.linkedToGitHub);
            this.gitHubAccountName(model.gitHubAccountName);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Boolean getLinkedToGitHub() {
            return this.linkedToGitHub;
        }

        @Override
        public final Builder linkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
            return this;
        }

        public final void setLinkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
        }

        public final String getGitHubAccountName() {
            return this.gitHubAccountName;
        }

        @Override
        public final Builder gitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
            return this;
        }

        public final void setGitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
        }

        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationInfo> {
        public Builder applicationId(String var1);

        public Builder applicationName(String var1);

        public Builder createTime(Instant var1);

        public Builder linkedToGitHub(Boolean var1);

        public Builder gitHubAccountName(String var1);
    }
}

