/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.TimeRange;

@SdkInternalApi
public class TimeRangeMarshaller {
    private static final MarshallingInfo<Date> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("start").build();
    private static final MarshallingInfo<Date> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("end").build();
    private static final TimeRangeMarshaller instance = new TimeRangeMarshaller();

    public static TimeRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(TimeRange timeRange, ProtocolMarshaller protocolMarshaller) {
        if (timeRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)timeRange.start(), START_BINDING);
            protocolMarshaller.marshall((Object)timeRange.end(), END_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

