/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;

@SdkInternalApi
public class LifecycleEventMarshaller {
    private static final MarshallingInfo<String> LIFECYCLEEVENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleEventName").build();
    private static final MarshallingInfo<StructuredPojo> DIAGNOSTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diagnostics").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final LifecycleEventMarshaller instance = new LifecycleEventMarshaller();

    public static LifecycleEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(LifecycleEvent lifecycleEvent, ProtocolMarshaller protocolMarshaller) {
        if (lifecycleEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lifecycleEvent.lifecycleEventName(), LIFECYCLEEVENTNAME_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.diagnostics(), DIAGNOSTICS_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

