/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeconnections.CodeConnectionsAsyncClient;
import software.amazon.awssdk.services.codeconnections.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListConnectionsResponse;

public class ListConnectionsPublisher
implements SdkPublisher<ListConnectionsResponse> {
    private final CodeConnectionsAsyncClient client;
    private final ListConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectionsPublisher(CodeConnectionsAsyncClient client, ListConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectionsPublisher(CodeConnectionsAsyncClient client, ListConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListConnectionsResponseFetcher
    implements AsyncPageFetcher<ListConnectionsResponse> {
        private ListConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectionsResponse> nextPage(ListConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionsPublisher.this.client.listConnections(ListConnectionsPublisher.this.firstRequest);
            }
            return ListConnectionsPublisher.this.client.listConnections((ListConnectionsRequest)((Object)ListConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

