/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsResponse;
import software.amazon.awssdk.services.codeconnections.model.ResourceSyncAttempt;
import software.amazon.awssdk.services.codeconnections.model.Revision;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSyncStatusResponse
extends CodeConnectionsResponse
implements ToCopyableBuilder<Builder, GetResourceSyncStatusResponse> {
    private static final SdkField<Revision> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DesiredState").getter(GetResourceSyncStatusResponse.getter(GetResourceSyncStatusResponse::desiredState)).setter(GetResourceSyncStatusResponse.setter(Builder::desiredState)).constructor(Revision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<ResourceSyncAttempt> LATEST_SUCCESSFUL_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestSuccessfulSync").getter(GetResourceSyncStatusResponse.getter(GetResourceSyncStatusResponse::latestSuccessfulSync)).setter(GetResourceSyncStatusResponse.setter(Builder::latestSuccessfulSync)).constructor(ResourceSyncAttempt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSuccessfulSync").build()}).build();
    private static final SdkField<ResourceSyncAttempt> LATEST_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestSync").getter(GetResourceSyncStatusResponse.getter(GetResourceSyncStatusResponse::latestSync)).setter(GetResourceSyncStatusResponse.setter(Builder::latestSync)).constructor(ResourceSyncAttempt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSync").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD, LATEST_SUCCESSFUL_SYNC_FIELD, LATEST_SYNC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DesiredState", DESIRED_STATE_FIELD);
            this.put("LatestSuccessfulSync", LATEST_SUCCESSFUL_SYNC_FIELD);
            this.put("LatestSync", LATEST_SYNC_FIELD);
        }
    });
    private final Revision desiredState;
    private final ResourceSyncAttempt latestSuccessfulSync;
    private final ResourceSyncAttempt latestSync;

    private GetResourceSyncStatusResponse(BuilderImpl builder) {
        super(builder);
        this.desiredState = builder.desiredState;
        this.latestSuccessfulSync = builder.latestSuccessfulSync;
        this.latestSync = builder.latestSync;
    }

    public final Revision desiredState() {
        return this.desiredState;
    }

    public final ResourceSyncAttempt latestSuccessfulSync() {
        return this.latestSuccessfulSync;
    }

    public final ResourceSyncAttempt latestSync() {
        return this.latestSync;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredState());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSuccessfulSync());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSync());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSyncStatusResponse)) {
            return false;
        }
        GetResourceSyncStatusResponse other = (GetResourceSyncStatusResponse)((Object)obj);
        return Objects.equals(this.desiredState(), other.desiredState()) && Objects.equals(this.latestSuccessfulSync(), other.latestSuccessfulSync()) && Objects.equals(this.latestSync(), other.latestSync());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceSyncStatusResponse").add("DesiredState", (Object)this.desiredState()).add("LatestSuccessfulSync", (Object)this.latestSuccessfulSync()).add("LatestSync", (Object)this.latestSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredState()));
            }
            case "LatestSuccessfulSync": {
                return Optional.ofNullable(clazz.cast(this.latestSuccessfulSync()));
            }
            case "LatestSync": {
                return Optional.ofNullable(clazz.cast(this.latestSync()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSyncStatusResponse, T> g) {
        return obj -> g.apply((GetResourceSyncStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeConnectionsResponse.BuilderImpl
    implements Builder {
        private Revision desiredState;
        private ResourceSyncAttempt latestSuccessfulSync;
        private ResourceSyncAttempt latestSync;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSyncStatusResponse model) {
            super(model);
            this.desiredState(model.desiredState);
            this.latestSuccessfulSync(model.latestSuccessfulSync);
            this.latestSync(model.latestSync);
        }

        public final Revision.Builder getDesiredState() {
            return this.desiredState != null ? this.desiredState.toBuilder() : null;
        }

        public final void setDesiredState(Revision.BuilderImpl desiredState) {
            this.desiredState = desiredState != null ? desiredState.build() : null;
        }

        @Override
        public final Builder desiredState(Revision desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        public final ResourceSyncAttempt.Builder getLatestSuccessfulSync() {
            return this.latestSuccessfulSync != null ? this.latestSuccessfulSync.toBuilder() : null;
        }

        public final void setLatestSuccessfulSync(ResourceSyncAttempt.BuilderImpl latestSuccessfulSync) {
            this.latestSuccessfulSync = latestSuccessfulSync != null ? latestSuccessfulSync.build() : null;
        }

        @Override
        public final Builder latestSuccessfulSync(ResourceSyncAttempt latestSuccessfulSync) {
            this.latestSuccessfulSync = latestSuccessfulSync;
            return this;
        }

        public final ResourceSyncAttempt.Builder getLatestSync() {
            return this.latestSync != null ? this.latestSync.toBuilder() : null;
        }

        public final void setLatestSync(ResourceSyncAttempt.BuilderImpl latestSync) {
            this.latestSync = latestSync != null ? latestSync.build() : null;
        }

        @Override
        public final Builder latestSync(ResourceSyncAttempt latestSync) {
            this.latestSync = latestSync;
            return this;
        }

        @Override
        public GetResourceSyncStatusResponse build() {
            return new GetResourceSyncStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeConnectionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSyncStatusResponse> {
        public Builder desiredState(Revision var1);

        default public Builder desiredState(Consumer<Revision.Builder> desiredState) {
            return this.desiredState((Revision)((Revision.Builder)Revision.builder().applyMutation(desiredState)).build());
        }

        public Builder latestSuccessfulSync(ResourceSyncAttempt var1);

        default public Builder latestSuccessfulSync(Consumer<ResourceSyncAttempt.Builder> latestSuccessfulSync) {
            return this.latestSuccessfulSync((ResourceSyncAttempt)((ResourceSyncAttempt.Builder)ResourceSyncAttempt.builder().applyMutation(latestSuccessfulSync)).build());
        }

        public Builder latestSync(ResourceSyncAttempt var1);

        default public Builder latestSync(Consumer<ResourceSyncAttempt.Builder> latestSync) {
            return this.latestSync((ResourceSyncAttempt)((ResourceSyncAttempt.Builder)ResourceSyncAttempt.builder().applyMutation(latestSync)).build());
        }
    }
}

