/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the file mode changes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetFileModeEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<SetFileModeEntry.Builder, SetFileModeEntry> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(SetFileModeEntry::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> FILE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileMode").getter(getter(SetFileModeEntry::fileModeAsString)).setter(setter(Builder::fileMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            FILE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final String fileMode;

    private SetFileModeEntry(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.fileMode = builder.fileMode;
    }

    /**
     * <p>
     * The full path to the file, including the name of the file.
     * </p>
     * 
     * @return The full path to the file, including the name of the file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The file mode for the file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The file mode for the file.
     * @see FileModeTypeEnum
     */
    public final FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(fileMode);
    }

    /**
     * <p>
     * The file mode for the file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The file mode for the file.
     * @see FileModeTypeEnum
     */
    public final String fileModeAsString() {
        return fileMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(fileModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetFileModeEntry)) {
            return false;
        }
        SetFileModeEntry other = (SetFileModeEntry) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(fileModeAsString(), other.fileModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetFileModeEntry").add("FilePath", filePath()).add("FileMode", fileModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "fileMode":
            return Optional.ofNullable(clazz.cast(fileModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filePath", FILE_PATH_FIELD);
        map.put("fileMode", FILE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetFileModeEntry, T> g) {
        return obj -> g.apply((SetFileModeEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetFileModeEntry> {
        /**
         * <p>
         * The full path to the file, including the name of the file.
         * </p>
         * 
         * @param filePath
         *        The full path to the file, including the name of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The file mode for the file.
         * </p>
         * 
         * @param fileMode
         *        The file mode for the file.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(String fileMode);

        /**
         * <p>
         * The file mode for the file.
         * </p>
         * 
         * @param fileMode
         *        The file mode for the file.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(FileModeTypeEnum fileMode);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private String fileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(SetFileModeEntry model) {
            filePath(model.filePath);
            fileMode(model.fileMode);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFileMode() {
            return fileMode;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        @Override
        public SetFileModeEntry build() {
            return new SetFileModeEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
