/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a repository name and ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryNameIdPair implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryNameIdPair.Builder, RepositoryNameIdPair> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(RepositoryNameIdPair::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryId").getter(getter(RepositoryNameIdPair::repositoryId)).setter(setter(Builder::repositoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            REPOSITORY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String repositoryId;

    private RepositoryNameIdPair(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.repositoryId = builder.repositoryId;
    }

    /**
     * <p>
     * The name associated with the repository.
     * </p>
     * 
     * @return The name associated with the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The ID associated with the repository.
     * </p>
     * 
     * @return The ID associated with the repository.
     */
    public final String repositoryId() {
        return repositoryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryNameIdPair)) {
            return false;
        }
        RepositoryNameIdPair other = (RepositoryNameIdPair) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(repositoryId(), other.repositoryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryNameIdPair").add("RepositoryName", repositoryName())
                .add("RepositoryId", repositoryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryId":
            return Optional.ofNullable(clazz.cast(repositoryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("repositoryId", REPOSITORY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryNameIdPair, T> g) {
        return obj -> g.apply((RepositoryNameIdPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryNameIdPair> {
        /**
         * <p>
         * The name associated with the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The ID associated with the repository.
         * </p>
         * 
         * @param repositoryId
         *        The ID associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryId(String repositoryId);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String repositoryId;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryNameIdPair model) {
            repositoryName(model.repositoryName);
            repositoryId(model.repositoryId);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryId() {
            return repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        @Override
        public RepositoryNameIdPair build() {
            return new RepositoryNameIdPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
