/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the file operation conflicts in a merge operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeOperations implements SdkPojo, Serializable, ToCopyableBuilder<MergeOperations.Builder, MergeOperations> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(MergeOperations::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(MergeOperations::destinationAsString)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String destination;

    private MergeOperations(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The operation (add, modify, or delete) on a file in the source of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link ChangeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The operation (add, modify, or delete) on a file in the source of a merge or pull request.
     * @see ChangeTypeEnum
     */
    public final ChangeTypeEnum source() {
        return ChangeTypeEnum.fromValue(source);
    }

    /**
     * <p>
     * The operation (add, modify, or delete) on a file in the source of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link ChangeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The operation (add, modify, or delete) on a file in the source of a merge or pull request.
     * @see ChangeTypeEnum
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The operation on a file in the destination of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link ChangeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The operation on a file in the destination of a merge or pull request.
     * @see ChangeTypeEnum
     */
    public final ChangeTypeEnum destination() {
        return ChangeTypeEnum.fromValue(destination);
    }

    /**
     * <p>
     * The operation on a file in the destination of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link ChangeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The operation on a file in the destination of a merge or pull request.
     * @see ChangeTypeEnum
     */
    public final String destinationAsString() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeOperations)) {
            return false;
        }
        MergeOperations other = (MergeOperations) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString())
                && Objects.equals(destinationAsString(), other.destinationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeOperations").add("Source", sourceAsString()).add("Destination", destinationAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeOperations, T> g) {
        return obj -> g.apply((MergeOperations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeOperations> {
        /**
         * <p>
         * The operation (add, modify, or delete) on a file in the source of a merge or pull request.
         * </p>
         * 
         * @param source
         *        The operation (add, modify, or delete) on a file in the source of a merge or pull request.
         * @see ChangeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTypeEnum
         */
        Builder source(String source);

        /**
         * <p>
         * The operation (add, modify, or delete) on a file in the source of a merge or pull request.
         * </p>
         * 
         * @param source
         *        The operation (add, modify, or delete) on a file in the source of a merge or pull request.
         * @see ChangeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTypeEnum
         */
        Builder source(ChangeTypeEnum source);

        /**
         * <p>
         * The operation on a file in the destination of a merge or pull request.
         * </p>
         * 
         * @param destination
         *        The operation on a file in the destination of a merge or pull request.
         * @see ChangeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTypeEnum
         */
        Builder destination(String destination);

        /**
         * <p>
         * The operation on a file in the destination of a merge or pull request.
         * </p>
         * 
         * @param destination
         *        The operation on a file in the destination of a merge or pull request.
         * @see ChangeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTypeEnum
         */
        Builder destination(ChangeTypeEnum destination);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeOperations model) {
            source(model.source);
            destination(model.destination);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(ChangeTypeEnum source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(ChangeTypeEnum destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        @Override
        public MergeOperations build() {
            return new MergeOperations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
