/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse;

public class ListFileCommitHistoryIterable
implements SdkIterable<ListFileCommitHistoryResponse> {
    private final CodeCommitClient client;
    private final ListFileCommitHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFileCommitHistoryIterable(CodeCommitClient client, ListFileCommitHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFileCommitHistoryResponseFetcher();
    }

    public Iterator<ListFileCommitHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFileCommitHistoryResponseFetcher
    implements SyncPageFetcher<ListFileCommitHistoryResponse> {
        private ListFileCommitHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListFileCommitHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFileCommitHistoryResponse nextPage(ListFileCommitHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListFileCommitHistoryIterable.this.client.listFileCommitHistory(ListFileCommitHistoryIterable.this.firstRequest);
            }
            return ListFileCommitHistoryIterable.this.client.listFileCommitHistory((ListFileCommitHistoryRequest)((Object)ListFileCommitHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

