/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a get blob operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlobResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetBlobResponse.Builder, GetBlobResponse> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(GetBlobResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD));

    private final SdkBytes content;

    private GetBlobResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
    }

    /**
     * <p>
     * The content of the blob, usually a file.
     * </p>
     * 
     * @return The content of the blob, usually a file.
     */
    public SdkBytes content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlobResponse)) {
            return false;
        }
        GetBlobResponse other = (GetBlobResponse) obj;
        return Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBlobResponse").add("Content", content()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlobResponse, T> g) {
        return obj -> g.apply((GetBlobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBlobResponse> {
        /**
         * <p>
         * The content of the blob, usually a file.
         * </p>
         * 
         * @param content
         *        The content of the blob, usually a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(SdkBytes content);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private SdkBytes content;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlobResponse model) {
            super(model);
            content(model.content);
        }

        public final ByteBuffer getContent() {
            return content == null ? null : content.asByteBuffer();
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = StandardMemberCopier.copy(content);
            return this;
        }

        public final void setContent(ByteBuffer content) {
            content(content == null ? null : SdkBytes.fromByteBuffer(content));
        }

        @Override
        public GetBlobResponse build() {
            return new GetBlobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
