/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the user who made a specified commit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserInfo implements SdkPojo, Serializable, ToCopyableBuilder<UserInfo.Builder, UserInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserInfo::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserInfo::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EMAIL_FIELD,
            DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String email;

    private final String date;

    private UserInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.email = builder.email;
        this.date = builder.date;
    }

    /**
     * <p>
     * The name of the user who made the specified commit.
     * </p>
     * 
     * @return The name of the user who made the specified commit.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The email address associated with the user who made the commit, if any.
     * </p>
     * 
     * @return The email address associated with the user who made the commit, if any.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The date when the specified commit was commited, in timestamp format with GMT offset.
     * </p>
     * 
     * @return The date when the specified commit was commited, in timestamp format with GMT offset.
     */
    public String date() {
        return date;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(date());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(email(), other.email())
                && Objects.equals(date(), other.date());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserInfo").add("Name", name()).add("Email", email()).add("Date", date()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserInfo, T> g) {
        return obj -> g.apply((UserInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserInfo> {
        /**
         * <p>
         * The name of the user who made the specified commit.
         * </p>
         * 
         * @param name
         *        The name of the user who made the specified commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The email address associated with the user who made the commit, if any.
         * </p>
         * 
         * @param email
         *        The email address associated with the user who made the commit, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The date when the specified commit was commited, in timestamp format with GMT offset.
         * </p>
         * 
         * @param date
         *        The date when the specified commit was commited, in timestamp format with GMT offset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(String date);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String email;

        private String date;

        private BuilderImpl() {
        }

        private BuilderImpl(UserInfo model) {
            name(model.name);
            email(model.email);
            date(model.date);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getDate() {
            return date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        @Override
        public UserInfo build() {
            return new UserInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
