/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointParams;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCodeCatalystEndpointProvider
implements CodeCatalystEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CodeCatalystEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(CodeCatalystEndpointParams params, String region) {
        if (params.endpoint() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule2(params, region);
        if (result.isResolved()) {
            return result;
        }
        return DefaultCodeCatalystEndpointProvider.endpointRule7(params, region);
    }

    private static RuleResult endpointRule2(CodeCatalystEndpointParams params, String region) {
        RulePartition partitionResult;
        if (region == null && (partitionResult = RulesFunctions.awsPartition("us-west-2")) != null) {
            RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule3(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst.global." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(CodeCatalystEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue()) {
            if (!partitionResult.supportsFIPS()) {
                return RuleResult.error("Partition does not support FIPS.");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst-fips.global." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(CodeCatalystEndpointParams params, String region) {
        RulePartition partitionResult;
        if (region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null) {
            RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule8(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst.global." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(CodeCatalystEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue()) {
            if (!partitionResult.supportsFIPS()) {
                return RuleResult.error("Partition does not support FIPS.");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst-fips.global." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

