/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesItem;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse;

public class ListSourceRepositoriesPublisher
implements SdkPublisher<ListSourceRepositoriesResponse> {
    private final CodeCatalystAsyncClient client;
    private final ListSourceRepositoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourceRepositoriesPublisher(CodeCatalystAsyncClient client, ListSourceRepositoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourceRepositoriesPublisher(CodeCatalystAsyncClient client, ListSourceRepositoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourceRepositoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourceRepositoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListSourceRepositoriesItem> items() {
        Function<ListSourceRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourceRepositoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourceRepositoriesResponseFetcher
    implements AsyncPageFetcher<ListSourceRepositoriesResponse> {
        private ListSourceRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourceRepositoriesResponse> nextPage(ListSourceRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListSourceRepositoriesPublisher.this.client.listSourceRepositories(ListSourceRepositoriesPublisher.this.firstRequest);
            }
            return ListSourceRepositoriesPublisher.this.client.listSourceRepositories((ListSourceRepositoriesRequest)((Object)ListSourceRepositoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

