/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClientBuilder;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystServiceClientConfiguration;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystBaseClientBuilder;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;

@SdkInternalApi
final class DefaultCodeCatalystAsyncClientBuilder
extends DefaultCodeCatalystBaseClientBuilder<CodeCatalystAsyncClientBuilder, CodeCatalystAsyncClient>
implements CodeCatalystAsyncClientBuilder {
    DefaultCodeCatalystAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeCatalystAsyncClientBuilder endpointProvider(CodeCatalystEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public DefaultCodeCatalystAsyncClientBuilder tokenProvider(SdkTokenProvider tokenProvider) {
        this.clientConfiguration.option((ClientOption)AwsClientOption.TOKEN_PROVIDER, (Object)tokenProvider);
        return this;
    }

    protected final CodeCatalystAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeCatalystAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeCatalystServiceClientConfiguration serviceClientConfiguration = CodeCatalystServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeCatalystAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

