/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.AuthType;
import software.amazon.awssdk.services.codebuild.model.ServerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceCredentialsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceCredentialsInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceCredentialsInfo.getter(SourceCredentialsInfo::arn)).setter(SourceCredentialsInfo.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceCredentialsInfo.getter(SourceCredentialsInfo::serverTypeAsString)).setter(SourceCredentialsInfo.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceCredentialsInfo.getter(SourceCredentialsInfo::authTypeAsString)).setter(SourceCredentialsInfo.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, SERVER_TYPE_FIELD, AUTH_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String serverType;
    private final String authType;

    private SourceCredentialsInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.serverType = builder.serverType;
        this.authType = builder.authType;
    }

    public String arn() {
        return this.arn;
    }

    public ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public String serverTypeAsString() {
        return this.serverType;
    }

    public AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public String authTypeAsString() {
        return this.authType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCredentialsInfo)) {
            return false;
        }
        SourceCredentialsInfo other = (SourceCredentialsInfo)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"SourceCredentialsInfo").add("Arn", (Object)this.arn()).add("ServerType", (Object)this.serverTypeAsString()).add("AuthType", (Object)this.authTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCredentialsInfo, T> g) {
        return obj -> g.apply((SourceCredentialsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String serverType;
        private String authType;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCredentialsInfo model) {
            this.arn(model.arn);
            this.serverType(model.serverType);
            this.authType(model.authType);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getServerTypeAsString() {
            return this.serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType.toString());
            return this;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public final String getAuthTypeAsString() {
            return this.authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType.toString());
            return this;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        public SourceCredentialsInfo build() {
            return new SourceCredentialsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceCredentialsInfo> {
        public Builder arn(String var1);

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);
    }
}

