/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.CommandExecution;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxResponse;

public class ListCommandExecutionsForSandboxPublisher
implements SdkPublisher<ListCommandExecutionsForSandboxResponse> {
    private final CodeBuildAsyncClient client;
    private final ListCommandExecutionsForSandboxRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommandExecutionsForSandboxPublisher(CodeBuildAsyncClient client, ListCommandExecutionsForSandboxRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommandExecutionsForSandboxPublisher(CodeBuildAsyncClient client, ListCommandExecutionsForSandboxRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommandExecutionsForSandboxResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommandExecutionsForSandboxResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CommandExecution> commandExecutions() {
        Function<ListCommandExecutionsForSandboxResponse, Iterator> getIterator = response -> {
            if (response != null && response.commandExecutions() != null) {
                return response.commandExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCommandExecutionsForSandboxResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCommandExecutionsForSandboxResponseFetcher
    implements AsyncPageFetcher<ListCommandExecutionsForSandboxResponse> {
        private ListCommandExecutionsForSandboxResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandExecutionsForSandboxResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCommandExecutionsForSandboxResponse> nextPage(ListCommandExecutionsForSandboxResponse previousPage) {
            if (previousPage == null) {
                return ListCommandExecutionsForSandboxPublisher.this.client.listCommandExecutionsForSandbox(ListCommandExecutionsForSandboxPublisher.this.firstRequest);
            }
            return ListCommandExecutionsForSandboxPublisher.this.client.listCommandExecutionsForSandbox((ListCommandExecutionsForSandboxRequest)((Object)ListCommandExecutionsForSandboxPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

