/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.ComputeConfiguration;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.FleetOverflowBehavior;
import software.amazon.awssdk.services.codebuild.model.FleetStatus;
import software.amazon.awssdk.services.codebuild.model.ProxyConfiguration;
import software.amazon.awssdk.services.codebuild.model.ScalingConfigurationOutput;
import software.amazon.awssdk.services.codebuild.model.Tag;
import software.amazon.awssdk.services.codebuild.model.TagListCopier;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Fleet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Fleet> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Fleet.getter(Fleet::arn)).setter(Fleet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Fleet.getter(Fleet::name)).setter(Fleet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Fleet.getter(Fleet::id)).setter(Fleet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(Fleet.getter(Fleet::created)).setter(Fleet.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModified").getter(Fleet.getter(Fleet::lastModified)).setter(Fleet.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()}).build();
    private static final SdkField<FleetStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(Fleet.getter(Fleet::status)).setter(Fleet.setter(Builder::status)).constructor(FleetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("baseCapacity").getter(Fleet.getter(Fleet::baseCapacity)).setter(Fleet.setter(Builder::baseCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()}).build();
    private static final SdkField<String> ENVIRONMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentType").getter(Fleet.getter(Fleet::environmentTypeAsString)).setter(Fleet.setter(Builder::environmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentType").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeType").getter(Fleet.getter(Fleet::computeTypeAsString)).setter(Fleet.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()}).build();
    private static final SdkField<ComputeConfiguration> COMPUTE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeConfiguration").getter(Fleet.getter(Fleet::computeConfiguration)).setter(Fleet.setter(Builder::computeConfiguration)).constructor(ComputeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfiguration").build()}).build();
    private static final SdkField<ScalingConfigurationOutput> SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingConfiguration").getter(Fleet.getter(Fleet::scalingConfiguration)).setter(Fleet.setter(Builder::scalingConfiguration)).constructor(ScalingConfigurationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build()}).build();
    private static final SdkField<String> OVERFLOW_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overflowBehavior").getter(Fleet.getter(Fleet::overflowBehaviorAsString)).setter(Fleet.setter(Builder::overflowBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overflowBehavior").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(Fleet.getter(Fleet::vpcConfig)).setter(Fleet.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<ProxyConfiguration> PROXY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("proxyConfiguration").getter(Fleet.getter(Fleet::proxyConfiguration)).setter(Fleet.setter(Builder::proxyConfiguration)).constructor(ProxyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proxyConfiguration").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageId").getter(Fleet.getter(Fleet::imageId)).setter(Fleet.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<String> FLEET_SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetServiceRole").getter(Fleet.getter(Fleet::fleetServiceRole)).setter(Fleet.setter(Builder::fleetServiceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetServiceRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Fleet.getter(Fleet::tags)).setter(Fleet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ID_FIELD, CREATED_FIELD, LAST_MODIFIED_FIELD, STATUS_FIELD, BASE_CAPACITY_FIELD, ENVIRONMENT_TYPE_FIELD, COMPUTE_TYPE_FIELD, COMPUTE_CONFIGURATION_FIELD, SCALING_CONFIGURATION_FIELD, OVERFLOW_BEHAVIOR_FIELD, VPC_CONFIG_FIELD, PROXY_CONFIGURATION_FIELD, IMAGE_ID_FIELD, FLEET_SERVICE_ROLE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Fleet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String id;
    private final Instant created;
    private final Instant lastModified;
    private final FleetStatus status;
    private final Integer baseCapacity;
    private final String environmentType;
    private final String computeType;
    private final ComputeConfiguration computeConfiguration;
    private final ScalingConfigurationOutput scalingConfiguration;
    private final String overflowBehavior;
    private final VpcConfig vpcConfig;
    private final ProxyConfiguration proxyConfiguration;
    private final String imageId;
    private final String fleetServiceRole;
    private final List<Tag> tags;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.id = builder.id;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.status = builder.status;
        this.baseCapacity = builder.baseCapacity;
        this.environmentType = builder.environmentType;
        this.computeType = builder.computeType;
        this.computeConfiguration = builder.computeConfiguration;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.overflowBehavior = builder.overflowBehavior;
        this.vpcConfig = builder.vpcConfig;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.imageId = builder.imageId;
        this.fleetServiceRole = builder.fleetServiceRole;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final FleetStatus status() {
        return this.status;
    }

    public final Integer baseCapacity() {
        return this.baseCapacity;
    }

    public final EnvironmentType environmentType() {
        return EnvironmentType.fromValue(this.environmentType);
    }

    public final String environmentTypeAsString() {
        return this.environmentType;
    }

    public final ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final ComputeConfiguration computeConfiguration() {
        return this.computeConfiguration;
    }

    public final ScalingConfigurationOutput scalingConfiguration() {
        return this.scalingConfiguration;
    }

    public final FleetOverflowBehavior overflowBehavior() {
        return FleetOverflowBehavior.fromValue(this.overflowBehavior);
    }

    public final String overflowBehaviorAsString() {
        return this.overflowBehavior;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final ProxyConfiguration proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String fleetServiceRole() {
        return this.fleetServiceRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.overflowBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetServiceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.baseCapacity(), other.baseCapacity()) && Objects.equals(this.environmentTypeAsString(), other.environmentTypeAsString()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.computeConfiguration(), other.computeConfiguration()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration()) && Objects.equals(this.overflowBehaviorAsString(), other.overflowBehaviorAsString()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.proxyConfiguration(), other.proxyConfiguration()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.fleetServiceRole(), other.fleetServiceRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Fleet").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Created", (Object)this.created()).add("LastModified", (Object)this.lastModified()).add("Status", (Object)this.status()).add("BaseCapacity", (Object)this.baseCapacity()).add("EnvironmentType", (Object)this.environmentTypeAsString()).add("ComputeType", (Object)this.computeTypeAsString()).add("ComputeConfiguration", (Object)this.computeConfiguration()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).add("OverflowBehavior", (Object)this.overflowBehaviorAsString()).add("VpcConfig", (Object)this.vpcConfig()).add("ProxyConfiguration", (Object)this.proxyConfiguration()).add("ImageId", (Object)this.imageId()).add("FleetServiceRole", (Object)this.fleetServiceRole()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "lastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "baseCapacity": {
                return Optional.ofNullable(clazz.cast(this.baseCapacity()));
            }
            case "environmentType": {
                return Optional.ofNullable(clazz.cast(this.environmentTypeAsString()));
            }
            case "computeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "computeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computeConfiguration()));
            }
            case "scalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
            case "overflowBehavior": {
                return Optional.ofNullable(clazz.cast(this.overflowBehaviorAsString()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "proxyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.proxyConfiguration()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "fleetServiceRole": {
                return Optional.ofNullable(clazz.cast(this.fleetServiceRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("baseCapacity", BASE_CAPACITY_FIELD);
        map.put("environmentType", ENVIRONMENT_TYPE_FIELD);
        map.put("computeType", COMPUTE_TYPE_FIELD);
        map.put("computeConfiguration", COMPUTE_CONFIGURATION_FIELD);
        map.put("scalingConfiguration", SCALING_CONFIGURATION_FIELD);
        map.put("overflowBehavior", OVERFLOW_BEHAVIOR_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("proxyConfiguration", PROXY_CONFIGURATION_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("fleetServiceRole", FLEET_SERVICE_ROLE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Fleet, T> g) {
        return obj -> g.apply((Fleet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String id;
        private Instant created;
        private Instant lastModified;
        private FleetStatus status;
        private Integer baseCapacity;
        private String environmentType;
        private String computeType;
        private ComputeConfiguration computeConfiguration;
        private ScalingConfigurationOutput scalingConfiguration;
        private String overflowBehavior;
        private VpcConfig vpcConfig;
        private ProxyConfiguration proxyConfiguration;
        private String imageId;
        private String fleetServiceRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            this.arn(model.arn);
            this.name(model.name);
            this.id(model.id);
            this.created(model.created);
            this.lastModified(model.lastModified);
            this.status(model.status);
            this.baseCapacity(model.baseCapacity);
            this.environmentType(model.environmentType);
            this.computeType(model.computeType);
            this.computeConfiguration(model.computeConfiguration);
            this.scalingConfiguration(model.scalingConfiguration);
            this.overflowBehavior(model.overflowBehavior);
            this.vpcConfig(model.vpcConfig);
            this.proxyConfiguration(model.proxyConfiguration);
            this.imageId(model.imageId);
            this.fleetServiceRole(model.fleetServiceRole);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final FleetStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(FleetStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status = status;
            return this;
        }

        public final Integer getBaseCapacity() {
            return this.baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final String getEnvironmentType() {
            return this.environmentType;
        }

        public final void setEnvironmentType(String environmentType) {
            this.environmentType = environmentType;
        }

        @Override
        public final Builder environmentType(String environmentType) {
            this.environmentType = environmentType;
            return this;
        }

        @Override
        public final Builder environmentType(EnvironmentType environmentType) {
            this.environmentType(environmentType == null ? null : environmentType.toString());
            return this;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final ComputeConfiguration.Builder getComputeConfiguration() {
            return this.computeConfiguration != null ? this.computeConfiguration.toBuilder() : null;
        }

        public final void setComputeConfiguration(ComputeConfiguration.BuilderImpl computeConfiguration) {
            this.computeConfiguration = computeConfiguration != null ? computeConfiguration.build() : null;
        }

        @Override
        public final Builder computeConfiguration(ComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        public final ScalingConfigurationOutput.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfigurationOutput.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfigurationOutput scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final String getOverflowBehavior() {
            return this.overflowBehavior;
        }

        public final void setOverflowBehavior(String overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
        }

        @Override
        public final Builder overflowBehavior(String overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
            return this;
        }

        @Override
        public final Builder overflowBehavior(FleetOverflowBehavior overflowBehavior) {
            this.overflowBehavior(overflowBehavior == null ? null : overflowBehavior.toString());
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final ProxyConfiguration.Builder getProxyConfiguration() {
            return this.proxyConfiguration != null ? this.proxyConfiguration.toBuilder() : null;
        }

        public final void setProxyConfiguration(ProxyConfiguration.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        @Override
        public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getFleetServiceRole() {
            return this.fleetServiceRole;
        }

        public final void setFleetServiceRole(String fleetServiceRole) {
            this.fleetServiceRole = fleetServiceRole;
        }

        @Override
        public final Builder fleetServiceRole(String fleetServiceRole) {
            this.fleetServiceRole = fleetServiceRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Fleet build() {
            return new Fleet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Fleet> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder created(Instant var1);

        public Builder lastModified(Instant var1);

        public Builder status(FleetStatus var1);

        default public Builder status(Consumer<FleetStatus.Builder> status) {
            return this.status((FleetStatus)((FleetStatus.Builder)FleetStatus.builder().applyMutation(status)).build());
        }

        public Builder baseCapacity(Integer var1);

        public Builder environmentType(String var1);

        public Builder environmentType(EnvironmentType var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder computeConfiguration(ComputeConfiguration var1);

        default public Builder computeConfiguration(Consumer<ComputeConfiguration.Builder> computeConfiguration) {
            return this.computeConfiguration((ComputeConfiguration)((ComputeConfiguration.Builder)ComputeConfiguration.builder().applyMutation(computeConfiguration)).build());
        }

        public Builder scalingConfiguration(ScalingConfigurationOutput var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfigurationOutput.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfigurationOutput)((ScalingConfigurationOutput.Builder)ScalingConfigurationOutput.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder overflowBehavior(String var1);

        public Builder overflowBehavior(FleetOverflowBehavior var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder proxyConfiguration(ProxyConfiguration var1);

        default public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfiguration) {
            return this.proxyConfiguration((ProxyConfiguration)((ProxyConfiguration.Builder)ProxyConfiguration.builder().applyMutation(proxyConfiguration)).build());
        }

        public Builder imageId(String var1);

        public Builder fleetServiceRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

