/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse;

public class ListReportsForReportGroupIterable
implements SdkIterable<ListReportsForReportGroupResponse> {
    private final CodeBuildClient client;
    private final ListReportsForReportGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReportsForReportGroupIterable(CodeBuildClient client, ListReportsForReportGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReportsForReportGroupResponseFetcher();
    }

    public Iterator<ListReportsForReportGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> reports() {
        Function<ListReportsForReportGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.reports() != null) {
                return response.reports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReportsForReportGroupResponseFetcher
    implements SyncPageFetcher<ListReportsForReportGroupResponse> {
        private ListReportsForReportGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListReportsForReportGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReportsForReportGroupResponse nextPage(ListReportsForReportGroupResponse previousPage) {
            if (previousPage == null) {
                return ListReportsForReportGroupIterable.this.client.listReportsForReportGroup(ListReportsForReportGroupIterable.this.firstRequest);
            }
            return ListReportsForReportGroupIterable.this.client.listReportsForReportGroup((ListReportsForReportGroupRequest)((Object)ListReportsForReportGroupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

