/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportWithRawData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportWithRawData> {
    private static final SdkField<String> REPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportArn").getter(ReportWithRawData.getter(ReportWithRawData::reportArn)).setter(ReportWithRawData.setter(Builder::reportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArn").build()}).build();
    private static final SdkField<String> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("data").getter(ReportWithRawData.getter(ReportWithRawData::data)).setter(ReportWithRawData.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARN_FIELD, DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reportArn;
    private final String data;

    private ReportWithRawData(BuilderImpl builder) {
        this.reportArn = builder.reportArn;
        this.data = builder.data;
    }

    public final String reportArn() {
        return this.reportArn;
    }

    public final String data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportWithRawData)) {
            return false;
        }
        ReportWithRawData other = (ReportWithRawData)obj;
        return Objects.equals(this.reportArn(), other.reportArn()) && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"ReportWithRawData").add("ReportArn", (Object)this.reportArn()).add("Data", (Object)this.data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportArn": {
                return Optional.ofNullable(clazz.cast(this.reportArn()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportWithRawData, T> g) {
        return obj -> g.apply((ReportWithRawData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportArn;
        private String data;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportWithRawData model) {
            this.reportArn(model.reportArn);
            this.data(model.data);
        }

        public final String getReportArn() {
            return this.reportArn;
        }

        public final void setReportArn(String reportArn) {
            this.reportArn = reportArn;
        }

        @Override
        public final Builder reportArn(String reportArn) {
            this.reportArn = reportArn;
            return this;
        }

        public final String getData() {
            return this.data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public ReportWithRawData build() {
            return new ReportWithRawData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportWithRawData> {
        public Builder reportArn(String var1);

        public Builder data(String var1);
    }
}

