/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.CodeBuildClientBuilder;
import software.amazon.awssdk.services.codebuild.CodeBuildServiceClientConfiguration;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildBaseClientBuilder;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildClient;
import software.amazon.awssdk.services.codebuild.endpoints.CodeBuildEndpointProvider;

@SdkInternalApi
final class DefaultCodeBuildClientBuilder
extends DefaultCodeBuildBaseClientBuilder<CodeBuildClientBuilder, CodeBuildClient>
implements CodeBuildClientBuilder {
    DefaultCodeBuildClientBuilder() {
    }

    @Override
    public DefaultCodeBuildClientBuilder endpointProvider(CodeBuildEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeBuildClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeBuildClientBuilder.validateClientOptions(clientConfiguration);
        CodeBuildServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeBuildClient client = new DefaultCodeBuildClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeBuildServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeBuildServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

