/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnvironmentType {
    WINDOWS_CONTAINER("WINDOWS_CONTAINER"),
    LINUX_CONTAINER("LINUX_CONTAINER"),
    LINUX_GPU_CONTAINER("LINUX_GPU_CONTAINER"),
    ARM_CONTAINER("ARM_CONTAINER"),
    WINDOWS_SERVER_2019_CONTAINER("WINDOWS_SERVER_2019_CONTAINER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnvironmentType> VALUE_MAP;
    private final String value;

    private EnvironmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnvironmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnvironmentType> knownValues() {
        EnumSet<EnvironmentType> knownValues = EnumSet.allOf(EnvironmentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnvironmentType.class, EnvironmentType::toString);
    }
}

