/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType;
import software.amazon.awssdk.services.codebuild.model.PhaseContext;
import software.amazon.awssdk.services.codebuild.model.PhaseContextsCopier;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildBatchPhase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuildBatchPhase> {
    private static final SdkField<String> PHASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("phaseType").getter(BuildBatchPhase.getter(BuildBatchPhase::phaseTypeAsString)).setter(BuildBatchPhase.setter(Builder::phaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phaseType").build()}).build();
    private static final SdkField<String> PHASE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("phaseStatus").getter(BuildBatchPhase.getter(BuildBatchPhase::phaseStatusAsString)).setter(BuildBatchPhase.setter(Builder::phaseStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phaseStatus").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(BuildBatchPhase.getter(BuildBatchPhase::startTime)).setter(BuildBatchPhase.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(BuildBatchPhase.getter(BuildBatchPhase::endTime)).setter(BuildBatchPhase.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Long> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("durationInSeconds").getter(BuildBatchPhase.getter(BuildBatchPhase::durationInSeconds)).setter(BuildBatchPhase.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()}).build();
    private static final SdkField<List<PhaseContext>> CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contexts").getter(BuildBatchPhase.getter(BuildBatchPhase::contexts)).setter(BuildBatchPhase.setter(Builder::contexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhaseContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHASE_TYPE_FIELD, PHASE_STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, DURATION_IN_SECONDS_FIELD, CONTEXTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String phaseType;
    private final String phaseStatus;
    private final Instant startTime;
    private final Instant endTime;
    private final Long durationInSeconds;
    private final List<PhaseContext> contexts;

    private BuildBatchPhase(BuilderImpl builder) {
        this.phaseType = builder.phaseType;
        this.phaseStatus = builder.phaseStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.contexts = builder.contexts;
    }

    public final BuildBatchPhaseType phaseType() {
        return BuildBatchPhaseType.fromValue(this.phaseType);
    }

    public final String phaseTypeAsString() {
        return this.phaseType;
    }

    public final StatusType phaseStatus() {
        return StatusType.fromValue(this.phaseStatus);
    }

    public final String phaseStatusAsString() {
        return this.phaseStatus;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Long durationInSeconds() {
        return this.durationInSeconds;
    }

    public final boolean hasContexts() {
        return this.contexts != null && !(this.contexts instanceof SdkAutoConstructList);
    }

    public final List<PhaseContext> contexts() {
        return this.contexts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phaseStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContexts() ? this.contexts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildBatchPhase)) {
            return false;
        }
        BuildBatchPhase other = (BuildBatchPhase)obj;
        return Objects.equals(this.phaseTypeAsString(), other.phaseTypeAsString()) && Objects.equals(this.phaseStatusAsString(), other.phaseStatusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && this.hasContexts() == other.hasContexts() && Objects.equals(this.contexts(), other.contexts());
    }

    public final String toString() {
        return ToString.builder((String)"BuildBatchPhase").add("PhaseType", (Object)this.phaseTypeAsString()).add("PhaseStatus", (Object)this.phaseStatusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("Contexts", this.hasContexts() ? this.contexts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "phaseType": {
                return Optional.ofNullable(clazz.cast(this.phaseTypeAsString()));
            }
            case "phaseStatus": {
                return Optional.ofNullable(clazz.cast(this.phaseStatusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "durationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "contexts": {
                return Optional.ofNullable(clazz.cast(this.contexts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildBatchPhase, T> g) {
        return obj -> g.apply((BuildBatchPhase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phaseType;
        private String phaseStatus;
        private Instant startTime;
        private Instant endTime;
        private Long durationInSeconds;
        private List<PhaseContext> contexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuildBatchPhase model) {
            this.phaseType(model.phaseType);
            this.phaseStatus(model.phaseStatus);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.durationInSeconds(model.durationInSeconds);
            this.contexts(model.contexts);
        }

        public final String getPhaseType() {
            return this.phaseType;
        }

        @Override
        public final Builder phaseType(String phaseType) {
            this.phaseType = phaseType;
            return this;
        }

        @Override
        public final Builder phaseType(BuildBatchPhaseType phaseType) {
            this.phaseType(phaseType == null ? null : phaseType.toString());
            return this;
        }

        public final void setPhaseType(String phaseType) {
            this.phaseType = phaseType;
        }

        public final String getPhaseStatus() {
            return this.phaseStatus;
        }

        @Override
        public final Builder phaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
            return this;
        }

        @Override
        public final Builder phaseStatus(StatusType phaseStatus) {
            this.phaseStatus(phaseStatus == null ? null : phaseStatus.toString());
            return this;
        }

        public final void setPhaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Long getDurationInSeconds() {
            return this.durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public final Collection<PhaseContext.Builder> getContexts() {
            if (this.contexts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contexts != null ? (Collection)this.contexts.stream().map(PhaseContext::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contexts(Collection<PhaseContext> contexts) {
            this.contexts = PhaseContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(PhaseContext ... contexts) {
            this.contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(Consumer<PhaseContext.Builder> ... contexts) {
            this.contexts(Stream.of(contexts).map(c -> (PhaseContext)((PhaseContext.Builder)PhaseContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContexts(Collection<PhaseContext.BuilderImpl> contexts) {
            this.contexts = PhaseContextsCopier.copyFromBuilder(contexts);
        }

        public BuildBatchPhase build() {
            return new BuildBatchPhase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuildBatchPhase> {
        public Builder phaseType(String var1);

        public Builder phaseType(BuildBatchPhaseType var1);

        public Builder phaseStatus(String var1);

        public Builder phaseStatus(StatusType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder durationInSeconds(Long var1);

        public Builder contexts(Collection<PhaseContext> var1);

        public Builder contexts(PhaseContext ... var1);

        public Builder contexts(Consumer<PhaseContext.Builder> ... var1);
    }
}

