/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.ReportGroupArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReportGroupsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, ListReportGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReportGroupsResponse.getter(ListReportGroupsResponse::nextToken)).setter(ListReportGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> REPORT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportGroups").getter(ListReportGroupsResponse.getter(ListReportGroupsResponse::reportGroups)).setter(ListReportGroupsResponse.setter(Builder::reportGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REPORT_GROUPS_FIELD));
    private final String nextToken;
    private final List<String> reportGroups;

    private ListReportGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reportGroups = builder.reportGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasReportGroups() {
        return this.reportGroups != null && !(this.reportGroups instanceof SdkAutoConstructList);
    }

    public List<String> reportGroups() {
        return this.reportGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportGroups() ? this.reportGroups() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportGroupsResponse)) {
            return false;
        }
        ListReportGroupsResponse other = (ListReportGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReportGroups() == other.hasReportGroups() && Objects.equals(this.reportGroups(), other.reportGroups());
    }

    public String toString() {
        return ToString.builder((String)"ListReportGroupsResponse").add("NextToken", (Object)this.nextToken()).add("ReportGroups", this.hasReportGroups() ? this.reportGroups() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "reportGroups": {
                return Optional.ofNullable(clazz.cast(this.reportGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportGroupsResponse, T> g) {
        return obj -> g.apply((ListReportGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> reportGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reportGroups(model.reportGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getReportGroups() {
            if (this.reportGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportGroups;
        }

        @Override
        public final Builder reportGroups(Collection<String> reportGroups) {
            this.reportGroups = ReportGroupArnsCopier.copy(reportGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGroups(String ... reportGroups) {
            this.reportGroups(Arrays.asList(reportGroups));
            return this;
        }

        public final void setReportGroups(Collection<String> reportGroups) {
            this.reportGroups = ReportGroupArnsCopier.copy(reportGroups);
        }

        @Override
        public ListReportGroupsResponse build() {
            return new ListReportGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReportGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder reportGroups(Collection<String> var1);

        public Builder reportGroups(String ... var1);
    }
}

