/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBuildRequest extends CodeBuildRequest implements
        ToCopyableBuilder<StartBuildRequest.Builder, StartBuildRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_OVERRIDE_FIELD = SdkField
            .<List<ProjectSource>> builder(MarshallingType.LIST)
            .getter(getter(StartBuildRequest::secondarySourcesOverride))
            .setter(setter(Builder::secondarySourcesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesOverride").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD = SdkField
            .<List<ProjectSourceVersion>> builder(MarshallingType.LIST)
            .getter(getter(StartBuildRequest::secondarySourcesVersionOverride))
            .setter(setter(Builder::secondarySourcesVersionOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesVersionOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSourceVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSourceVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::sourceVersion)).setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final SdkField<ProjectArtifacts> ARTIFACTS_OVERRIDE_FIELD = SdkField
            .<ProjectArtifacts> builder(MarshallingType.SDK_POJO).getter(getter(StartBuildRequest::artifactsOverride))
            .setter(setter(Builder::artifactsOverride)).constructor(ProjectArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactsOverride").build()).build();

    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_OVERRIDE_FIELD = SdkField
            .<List<ProjectArtifacts>> builder(MarshallingType.LIST)
            .getter(getter(StartBuildRequest::secondaryArtifactsOverride))
            .setter(setter(Builder::secondaryArtifactsOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifactsOverride").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectArtifacts> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectArtifacts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EnvironmentVariable>> ENVIRONMENT_VARIABLES_OVERRIDE_FIELD = SdkField
            .<List<EnvironmentVariable>> builder(MarshallingType.LIST)
            .getter(getter(StartBuildRequest::environmentVariablesOverride))
            .setter(setter(Builder::environmentVariablesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariablesOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_TYPE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::sourceTypeOverrideAsString)).setter(setter(Builder::sourceTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTypeOverride").build())
            .build();

    private static final SdkField<String> SOURCE_LOCATION_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::sourceLocationOverride)).setter(setter(Builder::sourceLocationOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocationOverride").build())
            .build();

    private static final SdkField<SourceAuth> SOURCE_AUTH_OVERRIDE_FIELD = SdkField
            .<SourceAuth> builder(MarshallingType.SDK_POJO).getter(getter(StartBuildRequest::sourceAuthOverride))
            .setter(setter(Builder::sourceAuthOverride)).constructor(SourceAuth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAuthOverride").build())
            .build();

    private static final SdkField<Integer> GIT_CLONE_DEPTH_OVERRIDE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StartBuildRequest::gitCloneDepthOverride)).setter(setter(Builder::gitCloneDepthOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitCloneDepthOverride").build())
            .build();

    private static final SdkField<GitSubmodulesConfig> GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD = SdkField
            .<GitSubmodulesConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartBuildRequest::gitSubmodulesConfigOverride))
            .setter(setter(Builder::gitSubmodulesConfigOverride))
            .constructor(GitSubmodulesConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitSubmodulesConfigOverride")
                    .build()).build();

    private static final SdkField<String> BUILDSPEC_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::buildspecOverride)).setter(setter(Builder::buildspecOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildspecOverride").build()).build();

    private static final SdkField<Boolean> INSECURE_SSL_OVERRIDE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StartBuildRequest::insecureSslOverride)).setter(setter(Builder::insecureSslOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureSslOverride").build())
            .build();

    private static final SdkField<Boolean> REPORT_BUILD_STATUS_OVERRIDE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(StartBuildRequest::reportBuildStatusOverride))
            .setter(setter(Builder::reportBuildStatusOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportBuildStatusOverride").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_TYPE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::environmentTypeOverrideAsString)).setter(setter(Builder::environmentTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTypeOverride").build())
            .build();

    private static final SdkField<String> IMAGE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::imageOverride)).setter(setter(Builder::imageOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageOverride").build()).build();

    private static final SdkField<String> COMPUTE_TYPE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::computeTypeOverrideAsString)).setter(setter(Builder::computeTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypeOverride").build())
            .build();

    private static final SdkField<String> CERTIFICATE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::certificateOverride)).setter(setter(Builder::certificateOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateOverride").build())
            .build();

    private static final SdkField<ProjectCache> CACHE_OVERRIDE_FIELD = SdkField.<ProjectCache> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartBuildRequest::cacheOverride)).setter(setter(Builder::cacheOverride))
            .constructor(ProjectCache::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheOverride").build()).build();

    private static final SdkField<String> SERVICE_ROLE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::serviceRoleOverride)).setter(setter(Builder::serviceRoleOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleOverride").build())
            .build();

    private static final SdkField<Boolean> PRIVILEGED_MODE_OVERRIDE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StartBuildRequest::privilegedModeOverride)).setter(setter(Builder::privilegedModeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privilegedModeOverride").build())
            .build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(StartBuildRequest::timeoutInMinutesOverride))
            .setter(setter(Builder::timeoutInMinutesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutesOverride").build())
            .build();

    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StartBuildRequest::queuedTimeoutInMinutesOverride))
            .setter(setter(Builder::queuedTimeoutInMinutesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutesOverride")
                    .build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::encryptionKeyOverride)).setter(setter(Builder::encryptionKeyOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyOverride").build())
            .build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::idempotencyToken)).setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build()).build();

    private static final SdkField<LogsConfig> LOGS_CONFIG_OVERRIDE_FIELD = SdkField
            .<LogsConfig> builder(MarshallingType.SDK_POJO).getter(getter(StartBuildRequest::logsConfigOverride))
            .setter(setter(Builder::logsConfigOverride)).constructor(LogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfigOverride").build())
            .build();

    private static final SdkField<RegistryCredential> REGISTRY_CREDENTIAL_OVERRIDE_FIELD = SdkField
            .<RegistryCredential> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartBuildRequest::registryCredentialOverride))
            .setter(setter(Builder::registryCredentialOverride))
            .constructor(RegistryCredential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryCredentialOverride").build())
            .build();

    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StartBuildRequest::imagePullCredentialsTypeOverrideAsString))
            .setter(setter(Builder::imagePullCredentialsTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePullCredentialsTypeOverride")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            SECONDARY_SOURCES_OVERRIDE_FIELD, SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD, SOURCE_VERSION_FIELD,
            ARTIFACTS_OVERRIDE_FIELD, SECONDARY_ARTIFACTS_OVERRIDE_FIELD, ENVIRONMENT_VARIABLES_OVERRIDE_FIELD,
            SOURCE_TYPE_OVERRIDE_FIELD, SOURCE_LOCATION_OVERRIDE_FIELD, SOURCE_AUTH_OVERRIDE_FIELD,
            GIT_CLONE_DEPTH_OVERRIDE_FIELD, GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD, BUILDSPEC_OVERRIDE_FIELD,
            INSECURE_SSL_OVERRIDE_FIELD, REPORT_BUILD_STATUS_OVERRIDE_FIELD, ENVIRONMENT_TYPE_OVERRIDE_FIELD,
            IMAGE_OVERRIDE_FIELD, COMPUTE_TYPE_OVERRIDE_FIELD, CERTIFICATE_OVERRIDE_FIELD, CACHE_OVERRIDE_FIELD,
            SERVICE_ROLE_OVERRIDE_FIELD, PRIVILEGED_MODE_OVERRIDE_FIELD, TIMEOUT_IN_MINUTES_OVERRIDE_FIELD,
            QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD, ENCRYPTION_KEY_OVERRIDE_FIELD, IDEMPOTENCY_TOKEN_FIELD,
            LOGS_CONFIG_OVERRIDE_FIELD, REGISTRY_CREDENTIAL_OVERRIDE_FIELD, IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD));

    private final String projectName;

    private final List<ProjectSource> secondarySourcesOverride;

    private final List<ProjectSourceVersion> secondarySourcesVersionOverride;

    private final String sourceVersion;

    private final ProjectArtifacts artifactsOverride;

    private final List<ProjectArtifacts> secondaryArtifactsOverride;

    private final List<EnvironmentVariable> environmentVariablesOverride;

    private final String sourceTypeOverride;

    private final String sourceLocationOverride;

    private final SourceAuth sourceAuthOverride;

    private final Integer gitCloneDepthOverride;

    private final GitSubmodulesConfig gitSubmodulesConfigOverride;

    private final String buildspecOverride;

    private final Boolean insecureSslOverride;

    private final Boolean reportBuildStatusOverride;

    private final String environmentTypeOverride;

    private final String imageOverride;

    private final String computeTypeOverride;

    private final String certificateOverride;

    private final ProjectCache cacheOverride;

    private final String serviceRoleOverride;

    private final Boolean privilegedModeOverride;

    private final Integer timeoutInMinutesOverride;

    private final Integer queuedTimeoutInMinutesOverride;

    private final String encryptionKeyOverride;

    private final String idempotencyToken;

    private final LogsConfig logsConfigOverride;

    private final RegistryCredential registryCredentialOverride;

    private final String imagePullCredentialsTypeOverride;

    private StartBuildRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.secondarySourcesOverride = builder.secondarySourcesOverride;
        this.secondarySourcesVersionOverride = builder.secondarySourcesVersionOverride;
        this.sourceVersion = builder.sourceVersion;
        this.artifactsOverride = builder.artifactsOverride;
        this.secondaryArtifactsOverride = builder.secondaryArtifactsOverride;
        this.environmentVariablesOverride = builder.environmentVariablesOverride;
        this.sourceTypeOverride = builder.sourceTypeOverride;
        this.sourceLocationOverride = builder.sourceLocationOverride;
        this.sourceAuthOverride = builder.sourceAuthOverride;
        this.gitCloneDepthOverride = builder.gitCloneDepthOverride;
        this.gitSubmodulesConfigOverride = builder.gitSubmodulesConfigOverride;
        this.buildspecOverride = builder.buildspecOverride;
        this.insecureSslOverride = builder.insecureSslOverride;
        this.reportBuildStatusOverride = builder.reportBuildStatusOverride;
        this.environmentTypeOverride = builder.environmentTypeOverride;
        this.imageOverride = builder.imageOverride;
        this.computeTypeOverride = builder.computeTypeOverride;
        this.certificateOverride = builder.certificateOverride;
        this.cacheOverride = builder.cacheOverride;
        this.serviceRoleOverride = builder.serviceRoleOverride;
        this.privilegedModeOverride = builder.privilegedModeOverride;
        this.timeoutInMinutesOverride = builder.timeoutInMinutesOverride;
        this.queuedTimeoutInMinutesOverride = builder.queuedTimeoutInMinutesOverride;
        this.encryptionKeyOverride = builder.encryptionKeyOverride;
        this.idempotencyToken = builder.idempotencyToken;
        this.logsConfigOverride = builder.logsConfigOverride;
        this.registryCredentialOverride = builder.registryCredentialOverride;
        this.imagePullCredentialsTypeOverride = builder.imagePullCredentialsTypeOverride;
    }

    /**
     * <p>
     * The name of the AWS CodeBuild build project to start running a build.
     * </p>
     * 
     * @return The name of the AWS CodeBuild build project to start running a build.
     */
    public String projectName() {
        return projectName;
    }

    /**
     * Returns true if the SecondarySourcesOverride property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecondarySourcesOverride() {
        return secondarySourcesOverride != null && !(secondarySourcesOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondarySourcesOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProjectSource</code> objects.
     */
    public List<ProjectSource> secondarySourcesOverride() {
        return secondarySourcesOverride;
    }

    /**
     * Returns true if the SecondarySourcesVersionOverride property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasSecondarySourcesVersionOverride() {
        return secondarySourcesVersionOverride != null && !(secondarySourcesVersionOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
     * secondary sources to be used for this build only.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondarySourcesVersionOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
     *         secondary sources to be used for this build only.
     */
    public List<ProjectSourceVersion> secondarySourcesVersionOverride() {
        return secondarySourcesVersionOverride;
    }

    /**
     * <p>
     * A version of the build input to be built, for this build only. If not specified, the latest version is used. If
     * specified, must be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For AWS CodeCommit: the commit ID, branch, or Git tag to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the
     * source code you want to build. If a pull request ID is specified, it must use the format
     * <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's
     * HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you
     * want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default
     * branch's HEAD commit ID is used.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build input ZIP
     * file to use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the
     * build level) takes precedence.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
     * with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
     * </p>
     * 
     * @return A version of the build input to be built, for this build only. If not specified, the latest version is
     *         used. If specified, must be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For AWS CodeCommit: the commit ID, branch, or Git tag to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of
     *         the source code you want to build. If a pull request ID is specified, it must use the format
     *         <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
     *         branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code
     *         you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified,
     *         the default branch's HEAD commit ID is used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build
     *         input ZIP file to use.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at
     *         the build level) takes precedence.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
     *         Sample with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
     */
    public String sourceVersion() {
        return sourceVersion;
    }

    /**
     * <p>
     * Build output artifact settings that override, for this build only, the latest ones already defined in the build
     * project.
     * </p>
     * 
     * @return Build output artifact settings that override, for this build only, the latest ones already defined in the
     *         build project.
     */
    public ProjectArtifacts artifactsOverride() {
        return artifactsOverride;
    }

    /**
     * Returns true if the SecondaryArtifactsOverride property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasSecondaryArtifactsOverride() {
        return secondaryArtifactsOverride != null && !(secondaryArtifactsOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectArtifacts</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondaryArtifactsOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProjectArtifacts</code> objects.
     */
    public List<ProjectArtifacts> secondaryArtifactsOverride() {
        return secondaryArtifactsOverride;
    }

    /**
     * Returns true if the EnvironmentVariablesOverride property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasEnvironmentVariablesOverride() {
        return environmentVariablesOverride != null && !(environmentVariablesOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of environment variables that overrides, for this build only, the latest ones already defined in the build
     * project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironmentVariablesOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of environment variables that overrides, for this build only, the latest ones already defined in
     *         the build project.
     */
    public List<EnvironmentVariable> environmentVariablesOverride() {
        return environmentVariablesOverride;
    }

    /**
     * <p>
     * A source input type, for this build, that overrides the source input defined in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTypeOverride} will return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sourceTypeOverrideAsString}.
     * </p>
     * 
     * @return A source input type, for this build, that overrides the source input defined in the build project.
     * @see SourceType
     */
    public SourceType sourceTypeOverride() {
        return SourceType.fromValue(sourceTypeOverride);
    }

    /**
     * <p>
     * A source input type, for this build, that overrides the source input defined in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTypeOverride} will return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sourceTypeOverrideAsString}.
     * </p>
     * 
     * @return A source input type, for this build, that overrides the source input defined in the build project.
     * @see SourceType
     */
    public String sourceTypeOverrideAsString() {
        return sourceTypeOverride;
    }

    /**
     * <p>
     * A location that overrides, for this build, the source location for the one defined in the build project.
     * </p>
     * 
     * @return A location that overrides, for this build, the source location for the one defined in the build project.
     */
    public String sourceLocationOverride() {
        return sourceLocationOverride;
    }

    /**
     * <p>
     * An authorization type for this build that overrides the one defined in the build project. This override applies
     * only if the build project's source is BitBucket or GitHub.
     * </p>
     * 
     * @return An authorization type for this build that overrides the one defined in the build project. This override
     *         applies only if the build project's source is BitBucket or GitHub.
     */
    public SourceAuth sourceAuthOverride() {
        return sourceAuthOverride;
    }

    /**
     * <p>
     * The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any previous
     * depth of history defined in the build project.
     * </p>
     * 
     * @return The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any
     *         previous depth of history defined in the build project.
     */
    public Integer gitCloneDepthOverride() {
        return gitCloneDepthOverride;
    }

    /**
     * <p>
     * Information about the Git submodules configuration for this build of an AWS CodeBuild build project.
     * </p>
     * 
     * @return Information about the Git submodules configuration for this build of an AWS CodeBuild build project.
     */
    public GitSubmodulesConfig gitSubmodulesConfigOverride() {
        return gitSubmodulesConfigOverride;
    }

    /**
     * <p>
     * A build spec declaration that overrides, for this build only, the latest one already defined in the build
     * project.
     * </p>
     * 
     * @return A build spec declaration that overrides, for this build only, the latest one already defined in the build
     *         project.
     */
    public String buildspecOverride() {
        return buildspecOverride;
    }

    /**
     * <p>
     * Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure SSL
     * setting determines whether to ignore SSL warnings while connecting to the project source code. This override
     * applies only if the build's source is GitHub Enterprise.
     * </p>
     * 
     * @return Enable this flag to override the insecure SSL setting that is specified in the build project. The
     *         insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source
     *         code. This override applies only if the build's source is GitHub Enterprise.
     */
    public Boolean insecureSslOverride() {
        return insecureSslOverride;
    }

    /**
     * <p>
     * Set to true to report to your source provider the status of a build's start and completion. If you use this
     * option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an invalidInputException is
     * thrown.
     * </p>
     * <note>
     * <p>
     * The status of a build triggered by a webhook is always reported to your source provider.
     * </p>
     * </note>
     * 
     * @return Set to true to report to your source provider the status of a build's start and completion. If you use
     *         this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an
     *         invalidInputException is thrown. </p> <note>
     *         <p>
     *         The status of a build triggered by a webhook is always reported to your source provider.
     *         </p>
     */
    public Boolean reportBuildStatusOverride() {
        return reportBuildStatusOverride;
    }

    /**
     * <p>
     * A container type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #environmentTypeOverride} will return {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #environmentTypeOverrideAsString}.
     * </p>
     * 
     * @return A container type for this build that overrides the one specified in the build project.
     * @see EnvironmentType
     */
    public EnvironmentType environmentTypeOverride() {
        return EnvironmentType.fromValue(environmentTypeOverride);
    }

    /**
     * <p>
     * A container type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #environmentTypeOverride} will return {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #environmentTypeOverrideAsString}.
     * </p>
     * 
     * @return A container type for this build that overrides the one specified in the build project.
     * @see EnvironmentType
     */
    public String environmentTypeOverrideAsString() {
        return environmentTypeOverride;
    }

    /**
     * <p>
     * The name of an image for this build that overrides the one specified in the build project.
     * </p>
     * 
     * @return The name of an image for this build that overrides the one specified in the build project.
     */
    public String imageOverride() {
        return imageOverride;
    }

    /**
     * <p>
     * The name of a compute type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #computeTypeOverride} will return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #computeTypeOverrideAsString}.
     * </p>
     * 
     * @return The name of a compute type for this build that overrides the one specified in the build project.
     * @see ComputeType
     */
    public ComputeType computeTypeOverride() {
        return ComputeType.fromValue(computeTypeOverride);
    }

    /**
     * <p>
     * The name of a compute type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #computeTypeOverride} will return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #computeTypeOverrideAsString}.
     * </p>
     * 
     * @return The name of a compute type for this build that overrides the one specified in the build project.
     * @see ComputeType
     */
    public String computeTypeOverrideAsString() {
        return computeTypeOverride;
    }

    /**
     * <p>
     * The name of a certificate for this build that overrides the one specified in the build project.
     * </p>
     * 
     * @return The name of a certificate for this build that overrides the one specified in the build project.
     */
    public String certificateOverride() {
        return certificateOverride;
    }

    /**
     * <p>
     * A ProjectCache object specified for this build that overrides the one defined in the build project.
     * </p>
     * 
     * @return A ProjectCache object specified for this build that overrides the one defined in the build project.
     */
    public ProjectCache cacheOverride() {
        return cacheOverride;
    }

    /**
     * <p>
     * The name of a service role for this build that overrides the one specified in the build project.
     * </p>
     * 
     * @return The name of a service role for this build that overrides the one specified in the build project.
     */
    public String serviceRoleOverride() {
        return serviceRoleOverride;
    }

    /**
     * <p>
     * Enable this flag to override privileged mode in the build project.
     * </p>
     * 
     * @return Enable this flag to override privileged mode in the build project.
     */
    public Boolean privilegedModeOverride() {
        return privilegedModeOverride;
    }

    /**
     * <p>
     * The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest
     * setting already defined in the build project.
     * </p>
     * 
     * @return The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the
     *         latest setting already defined in the build project.
     */
    public Integer timeoutInMinutesOverride() {
        return timeoutInMinutesOverride;
    }

    /**
     * <p>
     * The number of minutes a build is allowed to be queued before it times out.
     * </p>
     * 
     * @return The number of minutes a build is allowed to be queued before it times out.
     */
    public Integer queuedTimeoutInMinutesOverride() {
        return queuedTimeoutInMinutesOverride;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) customer master key (CMK) that overrides the one specified in the build
     * project. The CMK key encrypts the build output artifacts.
     * </p>
     * <note>
     * <p>
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to
     * that key.
     * </p>
     * </note>
     * <p>
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
     * format <code>alias/<i>alias-name</i> </code>).
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) customer master key (CMK) that overrides the one specified in
     *         the build project. The CMK key encrypts the build output artifacts.</p> <note>
     *         <p>
     *         You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
     *         permission to that key.
     *         </p>
     *         </note>
     *         <p>
     *         You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
     *         the format <code>alias/<i>alias-name</i> </code>).
     */
    public String encryptionKeyOverride() {
        return encryptionKeyOverride;
    }

    /**
     * <p>
     * A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The token is
     * included in the StartBuild request and is valid for 12 hours. If you repeat the StartBuild request with the same
     * token, but change a parameter, AWS CodeBuild returns a parameter mismatch error.
     * </p>
     * 
     * @return A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The
     *         token is included in the StartBuild request and is valid for 12 hours. If you repeat the StartBuild
     *         request with the same token, but change a parameter, AWS CodeBuild returns a parameter mismatch error.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * Log settings for this build that override the log settings defined in the build project.
     * </p>
     * 
     * @return Log settings for this build that override the log settings defined in the build project.
     */
    public LogsConfig logsConfigOverride() {
        return logsConfigOverride;
    }

    /**
     * <p>
     * The credentials for access to a private registry.
     * </p>
     * 
     * @return The credentials for access to a private registry.
     */
    public RegistryCredential registryCredentialOverride() {
        return registryCredentialOverride;
    }

    /**
     * <p>
     * The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify your
     * ECR repository policy to trust AWS CodeBuild's service principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When using an AWS
     * CodeBuild curated image, you must use CODEBUILD credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imagePullCredentialsTypeOverride} will return {@link ImagePullCredentialsType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #imagePullCredentialsTypeOverrideAsString}.
     * </p>
     * 
     * @return The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you
     *         modify your ECR repository policy to trust AWS CodeBuild's service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When using
     *         an AWS CodeBuild curated image, you must use CODEBUILD credentials.
     * @see ImagePullCredentialsType
     */
    public ImagePullCredentialsType imagePullCredentialsTypeOverride() {
        return ImagePullCredentialsType.fromValue(imagePullCredentialsTypeOverride);
    }

    /**
     * <p>
     * The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify your
     * ECR repository policy to trust AWS CodeBuild's service principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When using an AWS
     * CodeBuild curated image, you must use CODEBUILD credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imagePullCredentialsTypeOverride} will return {@link ImagePullCredentialsType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #imagePullCredentialsTypeOverrideAsString}.
     * </p>
     * 
     * @return The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you
     *         modify your ECR repository policy to trust AWS CodeBuild's service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When using
     *         an AWS CodeBuild curated image, you must use CODEBUILD credentials.
     * @see ImagePullCredentialsType
     */
    public String imagePullCredentialsTypeOverrideAsString() {
        return imagePullCredentialsTypeOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySourcesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySourcesVersionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(artifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryArtifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(environmentVariablesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAuthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(gitCloneDepthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(gitSubmodulesConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(buildspecOverride());
        hashCode = 31 * hashCode + Objects.hashCode(insecureSslOverride());
        hashCode = 31 * hashCode + Objects.hashCode(reportBuildStatusOverride());
        hashCode = 31 * hashCode + Objects.hashCode(environmentTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageOverride());
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateOverride());
        hashCode = 31 * hashCode + Objects.hashCode(cacheOverride());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleOverride());
        hashCode = 31 * hashCode + Objects.hashCode(privilegedModeOverride());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(queuedTimeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyOverride());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(logsConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(registryCredentialOverride());
        hashCode = 31 * hashCode + Objects.hashCode(imagePullCredentialsTypeOverrideAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildRequest)) {
            return false;
        }
        StartBuildRequest other = (StartBuildRequest) obj;
        return Objects.equals(projectName(), other.projectName())
                && Objects.equals(secondarySourcesOverride(), other.secondarySourcesOverride())
                && Objects.equals(secondarySourcesVersionOverride(), other.secondarySourcesVersionOverride())
                && Objects.equals(sourceVersion(), other.sourceVersion())
                && Objects.equals(artifactsOverride(), other.artifactsOverride())
                && Objects.equals(secondaryArtifactsOverride(), other.secondaryArtifactsOverride())
                && Objects.equals(environmentVariablesOverride(), other.environmentVariablesOverride())
                && Objects.equals(sourceTypeOverrideAsString(), other.sourceTypeOverrideAsString())
                && Objects.equals(sourceLocationOverride(), other.sourceLocationOverride())
                && Objects.equals(sourceAuthOverride(), other.sourceAuthOverride())
                && Objects.equals(gitCloneDepthOverride(), other.gitCloneDepthOverride())
                && Objects.equals(gitSubmodulesConfigOverride(), other.gitSubmodulesConfigOverride())
                && Objects.equals(buildspecOverride(), other.buildspecOverride())
                && Objects.equals(insecureSslOverride(), other.insecureSslOverride())
                && Objects.equals(reportBuildStatusOverride(), other.reportBuildStatusOverride())
                && Objects.equals(environmentTypeOverrideAsString(), other.environmentTypeOverrideAsString())
                && Objects.equals(imageOverride(), other.imageOverride())
                && Objects.equals(computeTypeOverrideAsString(), other.computeTypeOverrideAsString())
                && Objects.equals(certificateOverride(), other.certificateOverride())
                && Objects.equals(cacheOverride(), other.cacheOverride())
                && Objects.equals(serviceRoleOverride(), other.serviceRoleOverride())
                && Objects.equals(privilegedModeOverride(), other.privilegedModeOverride())
                && Objects.equals(timeoutInMinutesOverride(), other.timeoutInMinutesOverride())
                && Objects.equals(queuedTimeoutInMinutesOverride(), other.queuedTimeoutInMinutesOverride())
                && Objects.equals(encryptionKeyOverride(), other.encryptionKeyOverride())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(logsConfigOverride(), other.logsConfigOverride())
                && Objects.equals(registryCredentialOverride(), other.registryCredentialOverride())
                && Objects.equals(imagePullCredentialsTypeOverrideAsString(), other.imagePullCredentialsTypeOverrideAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartBuildRequest").add("ProjectName", projectName())
                .add("SecondarySourcesOverride", secondarySourcesOverride())
                .add("SecondarySourcesVersionOverride", secondarySourcesVersionOverride()).add("SourceVersion", sourceVersion())
                .add("ArtifactsOverride", artifactsOverride()).add("SecondaryArtifactsOverride", secondaryArtifactsOverride())
                .add("EnvironmentVariablesOverride", environmentVariablesOverride())
                .add("SourceTypeOverride", sourceTypeOverrideAsString()).add("SourceLocationOverride", sourceLocationOverride())
                .add("SourceAuthOverride", sourceAuthOverride()).add("GitCloneDepthOverride", gitCloneDepthOverride())
                .add("GitSubmodulesConfigOverride", gitSubmodulesConfigOverride()).add("BuildspecOverride", buildspecOverride())
                .add("InsecureSslOverride", insecureSslOverride()).add("ReportBuildStatusOverride", reportBuildStatusOverride())
                .add("EnvironmentTypeOverride", environmentTypeOverrideAsString()).add("ImageOverride", imageOverride())
                .add("ComputeTypeOverride", computeTypeOverrideAsString()).add("CertificateOverride", certificateOverride())
                .add("CacheOverride", cacheOverride()).add("ServiceRoleOverride", serviceRoleOverride())
                .add("PrivilegedModeOverride", privilegedModeOverride())
                .add("TimeoutInMinutesOverride", timeoutInMinutesOverride())
                .add("QueuedTimeoutInMinutesOverride", queuedTimeoutInMinutesOverride())
                .add("EncryptionKeyOverride", encryptionKeyOverride()).add("IdempotencyToken", idempotencyToken())
                .add("LogsConfigOverride", logsConfigOverride()).add("RegistryCredentialOverride", registryCredentialOverride())
                .add("ImagePullCredentialsTypeOverride", imagePullCredentialsTypeOverrideAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "secondarySourcesOverride":
            return Optional.ofNullable(clazz.cast(secondarySourcesOverride()));
        case "secondarySourcesVersionOverride":
            return Optional.ofNullable(clazz.cast(secondarySourcesVersionOverride()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "artifactsOverride":
            return Optional.ofNullable(clazz.cast(artifactsOverride()));
        case "secondaryArtifactsOverride":
            return Optional.ofNullable(clazz.cast(secondaryArtifactsOverride()));
        case "environmentVariablesOverride":
            return Optional.ofNullable(clazz.cast(environmentVariablesOverride()));
        case "sourceTypeOverride":
            return Optional.ofNullable(clazz.cast(sourceTypeOverrideAsString()));
        case "sourceLocationOverride":
            return Optional.ofNullable(clazz.cast(sourceLocationOverride()));
        case "sourceAuthOverride":
            return Optional.ofNullable(clazz.cast(sourceAuthOverride()));
        case "gitCloneDepthOverride":
            return Optional.ofNullable(clazz.cast(gitCloneDepthOverride()));
        case "gitSubmodulesConfigOverride":
            return Optional.ofNullable(clazz.cast(gitSubmodulesConfigOverride()));
        case "buildspecOverride":
            return Optional.ofNullable(clazz.cast(buildspecOverride()));
        case "insecureSslOverride":
            return Optional.ofNullable(clazz.cast(insecureSslOverride()));
        case "reportBuildStatusOverride":
            return Optional.ofNullable(clazz.cast(reportBuildStatusOverride()));
        case "environmentTypeOverride":
            return Optional.ofNullable(clazz.cast(environmentTypeOverrideAsString()));
        case "imageOverride":
            return Optional.ofNullable(clazz.cast(imageOverride()));
        case "computeTypeOverride":
            return Optional.ofNullable(clazz.cast(computeTypeOverrideAsString()));
        case "certificateOverride":
            return Optional.ofNullable(clazz.cast(certificateOverride()));
        case "cacheOverride":
            return Optional.ofNullable(clazz.cast(cacheOverride()));
        case "serviceRoleOverride":
            return Optional.ofNullable(clazz.cast(serviceRoleOverride()));
        case "privilegedModeOverride":
            return Optional.ofNullable(clazz.cast(privilegedModeOverride()));
        case "timeoutInMinutesOverride":
            return Optional.ofNullable(clazz.cast(timeoutInMinutesOverride()));
        case "queuedTimeoutInMinutesOverride":
            return Optional.ofNullable(clazz.cast(queuedTimeoutInMinutesOverride()));
        case "encryptionKeyOverride":
            return Optional.ofNullable(clazz.cast(encryptionKeyOverride()));
        case "idempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "logsConfigOverride":
            return Optional.ofNullable(clazz.cast(logsConfigOverride()));
        case "registryCredentialOverride":
            return Optional.ofNullable(clazz.cast(registryCredentialOverride()));
        case "imagePullCredentialsTypeOverride":
            return Optional.ofNullable(clazz.cast(imagePullCredentialsTypeOverrideAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBuildRequest, T> g) {
        return obj -> g.apply((StartBuildRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartBuildRequest> {
        /**
         * <p>
         * The name of the AWS CodeBuild build project to start running a build.
         * </p>
         * 
         * @param projectName
         *        The name of the AWS CodeBuild build project to start running a build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySourcesOverride
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesOverride(Collection<ProjectSource> secondarySourcesOverride);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySourcesOverride
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesOverride(ProjectSource... secondarySourcesOverride);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSource>.Builder} avoiding the need
         * to create one manually via {@link List<ProjectSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondarySourcesOverride(List<ProjectSource>)}.
         * 
         * @param secondarySourcesOverride
         *        a consumer that will call methods on {@link List<ProjectSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySourcesOverride(List<ProjectSource>)
         */
        Builder secondarySourcesOverride(Consumer<ProjectSource.Builder>... secondarySourcesOverride);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
         * secondary sources to be used for this build only.
         * </p>
         * 
         * @param secondarySourcesVersionOverride
         *        An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the
         *        project's secondary sources to be used for this build only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> secondarySourcesVersionOverride);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
         * secondary sources to be used for this build only.
         * </p>
         * 
         * @param secondarySourcesVersionOverride
         *        An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the
         *        project's secondary sources to be used for this build only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesVersionOverride(ProjectSourceVersion... secondarySourcesVersionOverride);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
         * secondary sources to be used for this build only.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSourceVersion>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectSourceVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSourceVersion>.Builder#build()} is called immediately
         * and its result is passed to {@link #secondarySourcesVersionOverride(List<ProjectSourceVersion>)}.
         * 
         * @param secondarySourcesVersionOverride
         *        a consumer that will call methods on {@link List<ProjectSourceVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySourcesVersionOverride(List<ProjectSourceVersion>)
         */
        Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder>... secondarySourcesVersionOverride);

        /**
         * <p>
         * A version of the build input to be built, for this build only. If not specified, the latest version is used.
         * If specified, must be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For AWS CodeCommit: the commit ID, branch, or Git tag to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the
         * source code you want to build. If a pull request ID is specified, it must use the format
         * <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's
         * HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you
         * want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the
         * default branch's HEAD commit ID is used.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build input
         * ZIP file to use.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the
         * build level) takes precedence.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
         * Sample with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
         * </p>
         * 
         * @param sourceVersion
         *        A version of the build input to be built, for this build only. If not specified, the latest version is
         *        used. If specified, must be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For AWS CodeCommit: the commit ID, branch, or Git tag to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version
         *        of the source code you want to build. If a pull request ID is specified, it must use the format
         *        <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
         *        branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source
         *        code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not
         *        specified, the default branch's HEAD commit ID is used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build
         *        input ZIP file to use.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code>
         *        (at the build level) takes precedence.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source
         *        Version Sample with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         * <p>
         * Build output artifact settings that override, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * 
         * @param artifactsOverride
         *        Build output artifact settings that override, for this build only, the latest ones already defined in
         *        the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactsOverride(ProjectArtifacts artifactsOverride);

        /**
         * <p>
         * Build output artifact settings that override, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectArtifacts.Builder} avoiding the need to
         * create one manually via {@link ProjectArtifacts#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #artifactsOverride(ProjectArtifacts)}.
         * 
         * @param artifactsOverride
         *        a consumer that will call methods on {@link ProjectArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactsOverride(ProjectArtifacts)
         */
        default Builder artifactsOverride(Consumer<ProjectArtifacts.Builder> artifactsOverride) {
            return artifactsOverride(ProjectArtifacts.builder().applyMutation(artifactsOverride).build());
        }

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * 
         * @param secondaryArtifactsOverride
         *        An array of <code>ProjectArtifacts</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> secondaryArtifactsOverride);

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * 
         * @param secondaryArtifactsOverride
         *        An array of <code>ProjectArtifacts</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifactsOverride(ProjectArtifacts... secondaryArtifactsOverride);

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectArtifacts>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectArtifacts>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectArtifacts>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondaryArtifactsOverride(List<ProjectArtifacts>)}.
         * 
         * @param secondaryArtifactsOverride
         *        a consumer that will call methods on {@link List<ProjectArtifacts>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryArtifactsOverride(List<ProjectArtifacts>)
         */
        Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder>... secondaryArtifactsOverride);

        /**
         * <p>
         * A set of environment variables that overrides, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * 
         * @param environmentVariablesOverride
         *        A set of environment variables that overrides, for this build only, the latest ones already defined in
         *        the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride);

        /**
         * <p>
         * A set of environment variables that overrides, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * 
         * @param environmentVariablesOverride
         *        A set of environment variables that overrides, for this build only, the latest ones already defined in
         *        the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariablesOverride(EnvironmentVariable... environmentVariablesOverride);

        /**
         * <p>
         * A set of environment variables that overrides, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentVariable>.Builder} avoiding the
         * need to create one manually via {@link List<EnvironmentVariable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentVariable>.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentVariablesOverride(List<EnvironmentVariable>)}.
         * 
         * @param environmentVariablesOverride
         *        a consumer that will call methods on {@link List<EnvironmentVariable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentVariablesOverride(List<EnvironmentVariable>)
         */
        Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder>... environmentVariablesOverride);

        /**
         * <p>
         * A source input type, for this build, that overrides the source input defined in the build project.
         * </p>
         * 
         * @param sourceTypeOverride
         *        A source input type, for this build, that overrides the source input defined in the build project.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceTypeOverride(String sourceTypeOverride);

        /**
         * <p>
         * A source input type, for this build, that overrides the source input defined in the build project.
         * </p>
         * 
         * @param sourceTypeOverride
         *        A source input type, for this build, that overrides the source input defined in the build project.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceTypeOverride(SourceType sourceTypeOverride);

        /**
         * <p>
         * A location that overrides, for this build, the source location for the one defined in the build project.
         * </p>
         * 
         * @param sourceLocationOverride
         *        A location that overrides, for this build, the source location for the one defined in the build
         *        project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationOverride(String sourceLocationOverride);

        /**
         * <p>
         * An authorization type for this build that overrides the one defined in the build project. This override
         * applies only if the build project's source is BitBucket or GitHub.
         * </p>
         * 
         * @param sourceAuthOverride
         *        An authorization type for this build that overrides the one defined in the build project. This
         *        override applies only if the build project's source is BitBucket or GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAuthOverride(SourceAuth sourceAuthOverride);

        /**
         * <p>
         * An authorization type for this build that overrides the one defined in the build project. This override
         * applies only if the build project's source is BitBucket or GitHub.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceAuth.Builder} avoiding the need to create
         * one manually via {@link SourceAuth#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceAuth.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceAuthOverride(SourceAuth)}.
         * 
         * @param sourceAuthOverride
         *        a consumer that will call methods on {@link SourceAuth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAuthOverride(SourceAuth)
         */
        default Builder sourceAuthOverride(Consumer<SourceAuth.Builder> sourceAuthOverride) {
            return sourceAuthOverride(SourceAuth.builder().applyMutation(sourceAuthOverride).build());
        }

        /**
         * <p>
         * The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any
         * previous depth of history defined in the build project.
         * </p>
         * 
         * @param gitCloneDepthOverride
         *        The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any
         *        previous depth of history defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitCloneDepthOverride(Integer gitCloneDepthOverride);

        /**
         * <p>
         * Information about the Git submodules configuration for this build of an AWS CodeBuild build project.
         * </p>
         * 
         * @param gitSubmodulesConfigOverride
         *        Information about the Git submodules configuration for this build of an AWS CodeBuild build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitSubmodulesConfigOverride(GitSubmodulesConfig gitSubmodulesConfigOverride);

        /**
         * <p>
         * Information about the Git submodules configuration for this build of an AWS CodeBuild build project.
         * </p>
         * This is a convenience that creates an instance of the {@link GitSubmodulesConfig.Builder} avoiding the need
         * to create one manually via {@link GitSubmodulesConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link GitSubmodulesConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #gitSubmodulesConfigOverride(GitSubmodulesConfig)}.
         * 
         * @param gitSubmodulesConfigOverride
         *        a consumer that will call methods on {@link GitSubmodulesConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitSubmodulesConfigOverride(GitSubmodulesConfig)
         */
        default Builder gitSubmodulesConfigOverride(Consumer<GitSubmodulesConfig.Builder> gitSubmodulesConfigOverride) {
            return gitSubmodulesConfigOverride(GitSubmodulesConfig.builder().applyMutation(gitSubmodulesConfigOverride).build());
        }

        /**
         * <p>
         * A build spec declaration that overrides, for this build only, the latest one already defined in the build
         * project.
         * </p>
         * 
         * @param buildspecOverride
         *        A build spec declaration that overrides, for this build only, the latest one already defined in the
         *        build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildspecOverride(String buildspecOverride);

        /**
         * <p>
         * Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure
         * SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This
         * override applies only if the build's source is GitHub Enterprise.
         * </p>
         * 
         * @param insecureSslOverride
         *        Enable this flag to override the insecure SSL setting that is specified in the build project. The
         *        insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source
         *        code. This override applies only if the build's source is GitHub Enterprise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureSslOverride(Boolean insecureSslOverride);

        /**
         * <p>
         * Set to true to report to your source provider the status of a build's start and completion. If you use this
         * option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an invalidInputException is
         * thrown.
         * </p>
         * <note>
         * <p>
         * The status of a build triggered by a webhook is always reported to your source provider.
         * </p>
         * </note>
         * 
         * @param reportBuildStatusOverride
         *        Set to true to report to your source provider the status of a build's start and completion. If you use
         *        this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an
         *        invalidInputException is thrown. </p> <note>
         *        <p>
         *        The status of a build triggered by a webhook is always reported to your source provider.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportBuildStatusOverride(Boolean reportBuildStatusOverride);

        /**
         * <p>
         * A container type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param environmentTypeOverride
         *        A container type for this build that overrides the one specified in the build project.
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder environmentTypeOverride(String environmentTypeOverride);

        /**
         * <p>
         * A container type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param environmentTypeOverride
         *        A container type for this build that overrides the one specified in the build project.
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder environmentTypeOverride(EnvironmentType environmentTypeOverride);

        /**
         * <p>
         * The name of an image for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param imageOverride
         *        The name of an image for this build that overrides the one specified in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOverride(String imageOverride);

        /**
         * <p>
         * The name of a compute type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param computeTypeOverride
         *        The name of a compute type for this build that overrides the one specified in the build project.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeTypeOverride(String computeTypeOverride);

        /**
         * <p>
         * The name of a compute type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param computeTypeOverride
         *        The name of a compute type for this build that overrides the one specified in the build project.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeTypeOverride(ComputeType computeTypeOverride);

        /**
         * <p>
         * The name of a certificate for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param certificateOverride
         *        The name of a certificate for this build that overrides the one specified in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateOverride(String certificateOverride);

        /**
         * <p>
         * A ProjectCache object specified for this build that overrides the one defined in the build project.
         * </p>
         * 
         * @param cacheOverride
         *        A ProjectCache object specified for this build that overrides the one defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheOverride(ProjectCache cacheOverride);

        /**
         * <p>
         * A ProjectCache object specified for this build that overrides the one defined in the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectCache.Builder} avoiding the need to
         * create one manually via {@link ProjectCache#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectCache.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheOverride(ProjectCache)}.
         * 
         * @param cacheOverride
         *        a consumer that will call methods on {@link ProjectCache.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheOverride(ProjectCache)
         */
        default Builder cacheOverride(Consumer<ProjectCache.Builder> cacheOverride) {
            return cacheOverride(ProjectCache.builder().applyMutation(cacheOverride).build());
        }

        /**
         * <p>
         * The name of a service role for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param serviceRoleOverride
         *        The name of a service role for this build that overrides the one specified in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleOverride(String serviceRoleOverride);

        /**
         * <p>
         * Enable this flag to override privileged mode in the build project.
         * </p>
         * 
         * @param privilegedModeOverride
         *        Enable this flag to override privileged mode in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privilegedModeOverride(Boolean privilegedModeOverride);

        /**
         * <p>
         * The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest
         * setting already defined in the build project.
         * </p>
         * 
         * @param timeoutInMinutesOverride
         *        The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the
         *        latest setting already defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride);

        /**
         * <p>
         * The number of minutes a build is allowed to be queued before it times out.
         * </p>
         * 
         * @param queuedTimeoutInMinutesOverride
         *        The number of minutes a build is allowed to be queued before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) customer master key (CMK) that overrides the one specified in the
         * build project. The CMK key encrypts the build output artifacts.
         * </p>
         * <note>
         * <p>
         * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission
         * to that key.
         * </p>
         * </note>
         * <p>
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
         * format <code>alias/<i>alias-name</i> </code>).
         * </p>
         * 
         * @param encryptionKeyOverride
         *        The AWS Key Management Service (AWS KMS) customer master key (CMK) that overrides the one specified in
         *        the build project. The CMK key encrypts the build output artifacts.</p> <note>
         *        <p>
         *        You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
         *        permission to that key.
         *        </p>
         *        </note>
         *        <p>
         *        You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias
         *        (using the format <code>alias/<i>alias-name</i> </code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyOverride(String encryptionKeyOverride);

        /**
         * <p>
         * A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The
         * token is included in the StartBuild request and is valid for 12 hours. If you repeat the StartBuild request
         * with the same token, but change a parameter, AWS CodeBuild returns a parameter mismatch error.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request.
         *        The token is included in the StartBuild request and is valid for 12 hours. If you repeat the
         *        StartBuild request with the same token, but change a parameter, AWS CodeBuild returns a parameter
         *        mismatch error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Log settings for this build that override the log settings defined in the build project.
         * </p>
         * 
         * @param logsConfigOverride
         *        Log settings for this build that override the log settings defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsConfigOverride(LogsConfig logsConfigOverride);

        /**
         * <p>
         * Log settings for this build that override the log settings defined in the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link LogsConfig.Builder} avoiding the need to create
         * one manually via {@link LogsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logsConfigOverride(LogsConfig)}.
         * 
         * @param logsConfigOverride
         *        a consumer that will call methods on {@link LogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsConfigOverride(LogsConfig)
         */
        default Builder logsConfigOverride(Consumer<LogsConfig.Builder> logsConfigOverride) {
            return logsConfigOverride(LogsConfig.builder().applyMutation(logsConfigOverride).build());
        }

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * 
         * @param registryCredentialOverride
         *        The credentials for access to a private registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryCredentialOverride(RegistryCredential registryCredentialOverride);

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * This is a convenience that creates an instance of the {@link RegistryCredential.Builder} avoiding the need to
         * create one manually via {@link RegistryCredential#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistryCredential.Builder#build()} is called immediately and its
         * result is passed to {@link #registryCredentialOverride(RegistryCredential)}.
         * 
         * @param registryCredentialOverride
         *        a consumer that will call methods on {@link RegistryCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryCredentialOverride(RegistryCredential)
         */
        default Builder registryCredentialOverride(Consumer<RegistryCredential.Builder> registryCredentialOverride) {
            return registryCredentialOverride(RegistryCredential.builder().applyMutation(registryCredentialOverride).build());
        }

        /**
         * <p>
         * The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify
         * your ECR repository policy to trust AWS CodeBuild's service principal.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When using an
         * AWS CodeBuild curated image, you must use CODEBUILD credentials.
         * </p>
         * 
         * @param imagePullCredentialsTypeOverride
         *        The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you
         *        modify your ECR repository policy to trust AWS CodeBuild's service principal.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When
         *        using an AWS CodeBuild curated image, you must use CODEBUILD credentials.
         * @see ImagePullCredentialsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImagePullCredentialsType
         */
        Builder imagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride);

        /**
         * <p>
         * The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify
         * your ECR repository policy to trust AWS CodeBuild's service principal.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When using an
         * AWS CodeBuild curated image, you must use CODEBUILD credentials.
         * </p>
         * 
         * @param imagePullCredentialsTypeOverride
         *        The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you
         *        modify your ECR repository policy to trust AWS CodeBuild's service principal.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When
         *        using an AWS CodeBuild curated image, you must use CODEBUILD credentials.
         * @see ImagePullCredentialsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImagePullCredentialsType
         */
        Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType imagePullCredentialsTypeOverride);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String projectName;

        private List<ProjectSource> secondarySourcesOverride = DefaultSdkAutoConstructList.getInstance();

        private List<ProjectSourceVersion> secondarySourcesVersionOverride = DefaultSdkAutoConstructList.getInstance();

        private String sourceVersion;

        private ProjectArtifacts artifactsOverride;

        private List<ProjectArtifacts> secondaryArtifactsOverride = DefaultSdkAutoConstructList.getInstance();

        private List<EnvironmentVariable> environmentVariablesOverride = DefaultSdkAutoConstructList.getInstance();

        private String sourceTypeOverride;

        private String sourceLocationOverride;

        private SourceAuth sourceAuthOverride;

        private Integer gitCloneDepthOverride;

        private GitSubmodulesConfig gitSubmodulesConfigOverride;

        private String buildspecOverride;

        private Boolean insecureSslOverride;

        private Boolean reportBuildStatusOverride;

        private String environmentTypeOverride;

        private String imageOverride;

        private String computeTypeOverride;

        private String certificateOverride;

        private ProjectCache cacheOverride;

        private String serviceRoleOverride;

        private Boolean privilegedModeOverride;

        private Integer timeoutInMinutesOverride;

        private Integer queuedTimeoutInMinutesOverride;

        private String encryptionKeyOverride;

        private String idempotencyToken;

        private LogsConfig logsConfigOverride;

        private RegistryCredential registryCredentialOverride;

        private String imagePullCredentialsTypeOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildRequest model) {
            super(model);
            projectName(model.projectName);
            secondarySourcesOverride(model.secondarySourcesOverride);
            secondarySourcesVersionOverride(model.secondarySourcesVersionOverride);
            sourceVersion(model.sourceVersion);
            artifactsOverride(model.artifactsOverride);
            secondaryArtifactsOverride(model.secondaryArtifactsOverride);
            environmentVariablesOverride(model.environmentVariablesOverride);
            sourceTypeOverride(model.sourceTypeOverride);
            sourceLocationOverride(model.sourceLocationOverride);
            sourceAuthOverride(model.sourceAuthOverride);
            gitCloneDepthOverride(model.gitCloneDepthOverride);
            gitSubmodulesConfigOverride(model.gitSubmodulesConfigOverride);
            buildspecOverride(model.buildspecOverride);
            insecureSslOverride(model.insecureSslOverride);
            reportBuildStatusOverride(model.reportBuildStatusOverride);
            environmentTypeOverride(model.environmentTypeOverride);
            imageOverride(model.imageOverride);
            computeTypeOverride(model.computeTypeOverride);
            certificateOverride(model.certificateOverride);
            cacheOverride(model.cacheOverride);
            serviceRoleOverride(model.serviceRoleOverride);
            privilegedModeOverride(model.privilegedModeOverride);
            timeoutInMinutesOverride(model.timeoutInMinutesOverride);
            queuedTimeoutInMinutesOverride(model.queuedTimeoutInMinutesOverride);
            encryptionKeyOverride(model.encryptionKeyOverride);
            idempotencyToken(model.idempotencyToken);
            logsConfigOverride(model.logsConfigOverride);
            registryCredentialOverride(model.registryCredentialOverride);
            imagePullCredentialsTypeOverride(model.imagePullCredentialsTypeOverride);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Collection<ProjectSource.Builder> getSecondarySourcesOverride() {
            return secondarySourcesOverride != null ? secondarySourcesOverride.stream().map(ProjectSource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourcesOverride(Collection<ProjectSource> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copy(secondarySourcesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(ProjectSource... secondarySourcesOverride) {
            secondarySourcesOverride(Arrays.asList(secondarySourcesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(Consumer<ProjectSource.Builder>... secondarySourcesOverride) {
            secondarySourcesOverride(Stream.of(secondarySourcesOverride)
                    .map(c -> ProjectSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourcesOverride(Collection<ProjectSource.BuilderImpl> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copyFromBuilder(secondarySourcesOverride);
        }

        public final Collection<ProjectSourceVersion.Builder> getSecondarySourcesVersionOverride() {
            return secondarySourcesVersionOverride != null ? secondarySourcesVersionOverride.stream()
                    .map(ProjectSourceVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copy(secondarySourcesVersionOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(ProjectSourceVersion... secondarySourcesVersionOverride) {
            secondarySourcesVersionOverride(Arrays.asList(secondarySourcesVersionOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(
                Consumer<ProjectSourceVersion.Builder>... secondarySourcesVersionOverride) {
            secondarySourcesVersionOverride(Stream.of(secondarySourcesVersionOverride)
                    .map(c -> ProjectSourceVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourcesVersionOverride(
                Collection<ProjectSourceVersion.BuilderImpl> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier
                    .copyFromBuilder(secondarySourcesVersionOverride);
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final ProjectArtifacts.Builder getArtifactsOverride() {
            return artifactsOverride != null ? artifactsOverride.toBuilder() : null;
        }

        @Override
        public final Builder artifactsOverride(ProjectArtifacts artifactsOverride) {
            this.artifactsOverride = artifactsOverride;
            return this;
        }

        public final void setArtifactsOverride(ProjectArtifacts.BuilderImpl artifactsOverride) {
            this.artifactsOverride = artifactsOverride != null ? artifactsOverride.build() : null;
        }

        public final Collection<ProjectArtifacts.Builder> getSecondaryArtifactsOverride() {
            return secondaryArtifactsOverride != null ? secondaryArtifactsOverride.stream().map(ProjectArtifacts::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copy(secondaryArtifactsOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(ProjectArtifacts... secondaryArtifactsOverride) {
            secondaryArtifactsOverride(Arrays.asList(secondaryArtifactsOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder>... secondaryArtifactsOverride) {
            secondaryArtifactsOverride(Stream.of(secondaryArtifactsOverride)
                    .map(c -> ProjectArtifacts.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryArtifactsOverride(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifactsOverride);
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironmentVariablesOverride() {
            return environmentVariablesOverride != null ? environmentVariablesOverride.stream()
                    .map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copy(environmentVariablesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(EnvironmentVariable... environmentVariablesOverride) {
            environmentVariablesOverride(Arrays.asList(environmentVariablesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder>... environmentVariablesOverride) {
            environmentVariablesOverride(Stream.of(environmentVariablesOverride)
                    .map(c -> EnvironmentVariable.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentVariablesOverride(Collection<EnvironmentVariable.BuilderImpl> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copyFromBuilder(environmentVariablesOverride);
        }

        public final String getSourceTypeOverrideAsString() {
            return sourceTypeOverride;
        }

        @Override
        public final Builder sourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
            return this;
        }

        @Override
        public final Builder sourceTypeOverride(SourceType sourceTypeOverride) {
            this.sourceTypeOverride(sourceTypeOverride == null ? null : sourceTypeOverride.toString());
            return this;
        }

        public final void setSourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
        }

        public final String getSourceLocationOverride() {
            return sourceLocationOverride;
        }

        @Override
        public final Builder sourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
            return this;
        }

        public final void setSourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
        }

        public final SourceAuth.Builder getSourceAuthOverride() {
            return sourceAuthOverride != null ? sourceAuthOverride.toBuilder() : null;
        }

        @Override
        public final Builder sourceAuthOverride(SourceAuth sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride;
            return this;
        }

        public final void setSourceAuthOverride(SourceAuth.BuilderImpl sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride != null ? sourceAuthOverride.build() : null;
        }

        public final Integer getGitCloneDepthOverride() {
            return gitCloneDepthOverride;
        }

        @Override
        public final Builder gitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
            return this;
        }

        public final void setGitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
        }

        public final GitSubmodulesConfig.Builder getGitSubmodulesConfigOverride() {
            return gitSubmodulesConfigOverride != null ? gitSubmodulesConfigOverride.toBuilder() : null;
        }

        @Override
        public final Builder gitSubmodulesConfigOverride(GitSubmodulesConfig gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride;
            return this;
        }

        public final void setGitSubmodulesConfigOverride(GitSubmodulesConfig.BuilderImpl gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride != null ? gitSubmodulesConfigOverride.build() : null;
        }

        public final String getBuildspecOverride() {
            return buildspecOverride;
        }

        @Override
        public final Builder buildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
            return this;
        }

        public final void setBuildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
        }

        public final Boolean getInsecureSslOverride() {
            return insecureSslOverride;
        }

        @Override
        public final Builder insecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
            return this;
        }

        public final void setInsecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
        }

        public final Boolean getReportBuildStatusOverride() {
            return reportBuildStatusOverride;
        }

        @Override
        public final Builder reportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
            return this;
        }

        public final void setReportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
        }

        public final String getEnvironmentTypeOverrideAsString() {
            return environmentTypeOverride;
        }

        @Override
        public final Builder environmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
            return this;
        }

        @Override
        public final Builder environmentTypeOverride(EnvironmentType environmentTypeOverride) {
            this.environmentTypeOverride(environmentTypeOverride == null ? null : environmentTypeOverride.toString());
            return this;
        }

        public final void setEnvironmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
        }

        public final String getImageOverride() {
            return imageOverride;
        }

        @Override
        public final Builder imageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
            return this;
        }

        public final void setImageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
        }

        public final String getComputeTypeOverrideAsString() {
            return computeTypeOverride;
        }

        @Override
        public final Builder computeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
            return this;
        }

        @Override
        public final Builder computeTypeOverride(ComputeType computeTypeOverride) {
            this.computeTypeOverride(computeTypeOverride == null ? null : computeTypeOverride.toString());
            return this;
        }

        public final void setComputeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
        }

        public final String getCertificateOverride() {
            return certificateOverride;
        }

        @Override
        public final Builder certificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
            return this;
        }

        public final void setCertificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
        }

        public final ProjectCache.Builder getCacheOverride() {
            return cacheOverride != null ? cacheOverride.toBuilder() : null;
        }

        @Override
        public final Builder cacheOverride(ProjectCache cacheOverride) {
            this.cacheOverride = cacheOverride;
            return this;
        }

        public final void setCacheOverride(ProjectCache.BuilderImpl cacheOverride) {
            this.cacheOverride = cacheOverride != null ? cacheOverride.build() : null;
        }

        public final String getServiceRoleOverride() {
            return serviceRoleOverride;
        }

        @Override
        public final Builder serviceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
            return this;
        }

        public final void setServiceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
        }

        public final Boolean getPrivilegedModeOverride() {
            return privilegedModeOverride;
        }

        @Override
        public final Builder privilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
            return this;
        }

        public final void setPrivilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
        }

        public final Integer getTimeoutInMinutesOverride() {
            return timeoutInMinutesOverride;
        }

        @Override
        public final Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
            return this;
        }

        public final void setTimeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
        }

        public final Integer getQueuedTimeoutInMinutesOverride() {
            return queuedTimeoutInMinutesOverride;
        }

        @Override
        public final Builder queuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
            return this;
        }

        public final void setQueuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
        }

        public final String getEncryptionKeyOverride() {
            return encryptionKeyOverride;
        }

        @Override
        public final Builder encryptionKeyOverride(String encryptionKeyOverride) {
            this.encryptionKeyOverride = encryptionKeyOverride;
            return this;
        }

        public final void setEncryptionKeyOverride(String encryptionKeyOverride) {
            this.encryptionKeyOverride = encryptionKeyOverride;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final LogsConfig.Builder getLogsConfigOverride() {
            return logsConfigOverride != null ? logsConfigOverride.toBuilder() : null;
        }

        @Override
        public final Builder logsConfigOverride(LogsConfig logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride;
            return this;
        }

        public final void setLogsConfigOverride(LogsConfig.BuilderImpl logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride != null ? logsConfigOverride.build() : null;
        }

        public final RegistryCredential.Builder getRegistryCredentialOverride() {
            return registryCredentialOverride != null ? registryCredentialOverride.toBuilder() : null;
        }

        @Override
        public final Builder registryCredentialOverride(RegistryCredential registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride;
            return this;
        }

        public final void setRegistryCredentialOverride(RegistryCredential.BuilderImpl registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride != null ? registryCredentialOverride.build() : null;
        }

        public final String getImagePullCredentialsTypeOverrideAsString() {
            return imagePullCredentialsTypeOverride;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
            return this;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride(imagePullCredentialsTypeOverride == null ? null
                    : imagePullCredentialsTypeOverride.toString());
            return this;
        }

        public final void setImagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBuildRequest build() {
            return new StartBuildRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
