/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReportGroupRequest extends CodeBuildRequest implements
        ToCopyableBuilder<CreateReportGroupRequest.Builder, CreateReportGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReportGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReportGroupRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ReportExportConfig> EXPORT_CONFIG_FIELD = SdkField
            .<ReportExportConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateReportGroupRequest::exportConfig))
            .setter(setter(Builder::exportConfig)).constructor(ReportExportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            EXPORT_CONFIG_FIELD));

    private final String name;

    private final String type;

    private final ReportExportConfig exportConfig;

    private CreateReportGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.exportConfig = builder.exportConfig;
    }

    /**
     * <p>
     * The name of the report group.
     * </p>
     * 
     * @return The name of the report group.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of report group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of report group.
     * @see ReportType
     */
    public ReportType type() {
        return ReportType.fromValue(type);
    }

    /**
     * <p>
     * The type of report group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of report group.
     * @see ReportType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>ReportExportConfig</code> object that contains information about where the report group test results are
     * exported.
     * </p>
     * 
     * @return A <code>ReportExportConfig</code> object that contains information about where the report group test
     *         results are exported.
     */
    public ReportExportConfig exportConfig() {
        return exportConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReportGroupRequest)) {
            return false;
        }
        CreateReportGroupRequest other = (CreateReportGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(exportConfig(), other.exportConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReportGroupRequest").add("Name", name()).add("Type", typeAsString())
                .add("ExportConfig", exportConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "exportConfig":
            return Optional.ofNullable(clazz.cast(exportConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReportGroupRequest, T> g) {
        return obj -> g.apply((CreateReportGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReportGroupRequest> {
        /**
         * <p>
         * The name of the report group.
         * </p>
         * 
         * @param name
         *        The name of the report group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of report group.
         * </p>
         * 
         * @param type
         *        The type of report group.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of report group.
         * </p>
         * 
         * @param type
         *        The type of report group.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(ReportType type);

        /**
         * <p>
         * A <code>ReportExportConfig</code> object that contains information about where the report group test results
         * are exported.
         * </p>
         * 
         * @param exportConfig
         *        A <code>ReportExportConfig</code> object that contains information about where the report group test
         *        results are exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportConfig(ReportExportConfig exportConfig);

        /**
         * <p>
         * A <code>ReportExportConfig</code> object that contains information about where the report group test results
         * are exported.
         * </p>
         * This is a convenience that creates an instance of the {@link ReportExportConfig.Builder} avoiding the need to
         * create one manually via {@link ReportExportConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportExportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #exportConfig(ReportExportConfig)}.
         * 
         * @param exportConfig
         *        a consumer that will call methods on {@link ReportExportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportConfig(ReportExportConfig)
         */
        default Builder exportConfig(Consumer<ReportExportConfig.Builder> exportConfig) {
            return exportConfig(ReportExportConfig.builder().applyMutation(exportConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String name;

        private String type;

        private ReportExportConfig exportConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReportGroupRequest model) {
            super(model);
            name(model.name);
            type(model.type);
            exportConfig(model.exportConfig);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReportType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ReportExportConfig.Builder getExportConfig() {
            return exportConfig != null ? exportConfig.toBuilder() : null;
        }

        @Override
        public final Builder exportConfig(ReportExportConfig exportConfig) {
            this.exportConfig = exportConfig;
            return this;
        }

        public final void setExportConfig(ReportExportConfig.BuilderImpl exportConfig) {
            this.exportConfig = exportConfig != null ? exportConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReportGroupRequest build() {
            return new CreateReportGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
