/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ReportArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetReportsRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, BatchGetReportsRequest> {
    private static final SdkField<List<String>> REPORT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetReportsRequest.getter(BatchGetReportsRequest::reportArns)).setter(BatchGetReportsRequest.setter(Builder::reportArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARNS_FIELD));
    private final List<String> reportArns;

    private BatchGetReportsRequest(BuilderImpl builder) {
        super(builder);
        this.reportArns = builder.reportArns;
    }

    public List<String> reportArns() {
        return this.reportArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetReportsRequest)) {
            return false;
        }
        BatchGetReportsRequest other = (BatchGetReportsRequest)((Object)obj);
        return Objects.equals(this.reportArns(), other.reportArns());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetReportsRequest").add("ReportArns", this.reportArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportArns": {
                return Optional.ofNullable(clazz.cast(this.reportArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetReportsRequest, T> g) {
        return obj -> g.apply((BatchGetReportsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private List<String> reportArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetReportsRequest model) {
            super(model);
            this.reportArns(model.reportArns);
        }

        public final Collection<String> getReportArns() {
            return this.reportArns;
        }

        @Override
        public final Builder reportArns(Collection<String> reportArns) {
            this.reportArns = ReportArnsCopier.copy(reportArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportArns(String ... reportArns) {
            this.reportArns(Arrays.asList(reportArns));
            return this;
        }

        public final void setReportArns(Collection<String> reportArns) {
            this.reportArns = ReportArnsCopier.copy(reportArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetReportsRequest build() {
            return new BatchGetReportsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetReportsRequest> {
        public Builder reportArns(Collection<String> var1);

        public Builder reportArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

