/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.ArtifactNamespace;
import software.amazon.awssdk.services.codebuild.model.ArtifactPackaging;
import software.amazon.awssdk.services.codebuild.model.ArtifactsType;
import software.amazon.awssdk.services.codebuild.transform.ProjectArtifactsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProjectArtifacts
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectArtifacts> {
    private final String type;
    private final String location;
    private final String path;
    private final String namespaceType;
    private final String name;
    private final String packaging;

    private ProjectArtifacts(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.path = builder.path;
        this.namespaceType = builder.namespaceType;
        this.name = builder.name;
        this.packaging = builder.packaging;
    }

    public ArtifactsType type() {
        return ArtifactsType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public String path() {
        return this.path;
    }

    public ArtifactNamespace namespaceType() {
        return ArtifactNamespace.fromValue(this.namespaceType);
    }

    public String namespaceTypeString() {
        return this.namespaceType;
    }

    public String name() {
        return this.name;
    }

    public ArtifactPackaging packaging() {
        return ArtifactPackaging.fromValue(this.packaging);
    }

    public String packagingString() {
        return this.packaging;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectArtifacts)) {
            return false;
        }
        ProjectArtifacts other = (ProjectArtifacts)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.namespaceTypeString(), other.namespaceTypeString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.packagingString(), other.packagingString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.namespaceTypeString() != null) {
            sb.append("NamespaceType: ").append(this.namespaceTypeString()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.packagingString() != null) {
            sb.append("Packaging: ").append(this.packagingString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "namespaceType": {
                return Optional.of(clazz.cast(this.namespaceTypeString()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "packaging": {
                return Optional.of(clazz.cast(this.packagingString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectArtifactsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private String path;
        private String namespaceType;
        private String name;
        private String packaging;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectArtifacts model) {
            this.type(model.type);
            this.location(model.location);
            this.path(model.path);
            this.namespaceType(model.namespaceType);
            this.name(model.name);
            this.packaging(model.packaging);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactsType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getNamespaceType() {
            return this.namespaceType;
        }

        @Override
        public final Builder namespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
            return this;
        }

        @Override
        public final Builder namespaceType(ArtifactNamespace namespaceType) {
            this.namespaceType(namespaceType.toString());
            return this;
        }

        public final void setNamespaceType(String namespaceType) {
            this.namespaceType = namespaceType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPackaging() {
            return this.packaging;
        }

        @Override
        public final Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Override
        public final Builder packaging(ArtifactPackaging packaging) {
            this.packaging(packaging.toString());
            return this;
        }

        public final void setPackaging(String packaging) {
            this.packaging = packaging;
        }

        public ProjectArtifacts build() {
            return new ProjectArtifacts(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectArtifacts> {
        public Builder type(String var1);

        public Builder type(ArtifactsType var1);

        public Builder location(String var1);

        public Builder path(String var1);

        public Builder namespaceType(String var1);

        public Builder namespaceType(ArtifactNamespace var1);

        public Builder name(String var1);

        public Builder packaging(String var1);

        public Builder packaging(ArtifactPackaging var1);
    }
}

