/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.Tag;
import software.amazon.awssdk.services.codebuild.model.TagListCopier;
import software.amazon.awssdk.services.codebuild.transform.ProjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Project
implements StructuredPojo,
ToCopyableBuilder<Builder, Project> {
    private final String name;
    private final String arn;
    private final String description;
    private final ProjectSource source;
    private final ProjectArtifacts artifacts;
    private final ProjectEnvironment environment;
    private final String serviceRole;
    private final Integer timeoutInMinutes;
    private final String encryptionKey;
    private final List<Tag> tags;
    private final Instant created;
    private final Instant lastModified;

    private Project(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.source = builder.source;
        this.artifacts = builder.artifacts;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.encryptionKey = builder.encryptionKey;
        this.tags = builder.tags;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String description() {
        return this.description;
    }

    public ProjectSource source() {
        return this.source;
    }

    public ProjectArtifacts artifacts() {
        return this.artifacts;
    }

    public ProjectEnvironment environment() {
        return this.environment;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public String encryptionKey() {
        return this.encryptionKey;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Instant created() {
        return this.created;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.artifacts() == null ? 0 : this.artifacts().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInMinutes() == null ? 0 : this.timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.encryptionKey() == null ? 0 : this.encryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.lastModified() == null ? 0 : this.lastModified().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.artifacts() == null ^ this.artifacts() == null) {
            return false;
        }
        if (other.artifacts() != null && !other.artifacts().equals(this.artifacts())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.encryptionKey() == null ^ this.encryptionKey() == null) {
            return false;
        }
        if (other.encryptionKey() != null && !other.encryptionKey().equals(this.encryptionKey())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        return other.lastModified() == null || other.lastModified().equals(this.lastModified());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.artifacts() != null) {
            sb.append("Artifacts: ").append(this.artifacts()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.timeoutInMinutes()).append(",");
        }
        if (this.encryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.encryptionKey()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private ProjectSource source;
        private ProjectArtifacts artifacts;
        private ProjectEnvironment environment;
        private String serviceRole;
        private Integer timeoutInMinutes;
        private String encryptionKey;
        private List<Tag> tags;
        private Instant created;
        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.setName(model.name);
            this.setArn(model.arn);
            this.setDescription(model.description);
            this.setSource(model.source);
            this.setArtifacts(model.artifacts);
            this.setEnvironment(model.environment);
            this.setServiceRole(model.serviceRole);
            this.setTimeoutInMinutes(model.timeoutInMinutes);
            this.setEncryptionKey(model.encryptionKey);
            this.setTags(model.tags);
            this.setCreated(model.created);
            this.setLastModified(model.lastModified);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ProjectSource getSource() {
            return this.source;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ProjectSource source) {
            this.source = source;
        }

        public final ProjectArtifacts getArtifacts() {
            return this.artifacts;
        }

        @Override
        public final Builder artifacts(ProjectArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final void setArtifacts(ProjectArtifacts artifacts) {
            this.artifacts = artifacts;
        }

        public final ProjectEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(ProjectEnvironment environment) {
            this.environment = environment;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public Project build() {
            return new Project(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Project> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder source(ProjectSource var1);

        public Builder artifacts(ProjectArtifacts var1);

        public Builder environment(ProjectEnvironment var1);

        public Builder serviceRole(String var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder encryptionKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder created(Instant var1);

        public Builder lastModified(Instant var1);
    }
}

