/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartBuildRequestModelMarshaller {
    private static final MarshallingInfo<String> PROJECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("projectName").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYSOURCESOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondarySourcesOverride").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYSOURCESVERSIONOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondarySourcesVersionOverride").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTSOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactsOverride").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYARTIFACTSOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondaryArtifactsOverride").isBinary(false).build();
    private static final MarshallingInfo<List> ENVIRONMENTVARIABLESOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentVariablesOverride").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceTypeOverride").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCELOCATIONOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceLocationOverride").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCEAUTHOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceAuthOverride").isBinary(false).build();
    private static final MarshallingInfo<Integer> GITCLONEDEPTHOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gitCloneDepthOverride").isBinary(false).build();
    private static final MarshallingInfo<String> BUILDSPECOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildspecOverride").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INSECURESSLOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("insecureSslOverride").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REPORTBUILDSTATUSOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reportBuildStatusOverride").isBinary(false).build();
    private static final MarshallingInfo<String> ENVIRONMENTTYPEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentTypeOverride").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageOverride").isBinary(false).build();
    private static final MarshallingInfo<String> COMPUTETYPEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeTypeOverride").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateOverride").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CACHEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheOverride").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceRoleOverride").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PRIVILEGEDMODEOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privilegedModeOverride").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUTINMINUTESOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutInMinutesOverride").isBinary(false).build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("idempotencyToken").isBinary(false).build();
    private static final StartBuildRequestModelMarshaller INSTANCE = new StartBuildRequestModelMarshaller();

    private StartBuildRequestModelMarshaller() {
    }

    public static StartBuildRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartBuildRequest startBuildRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startBuildRequest), (String)"startBuildRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startBuildRequest.projectName(), PROJECTNAME_BINDING);
            protocolMarshaller.marshall(startBuildRequest.secondarySourcesOverride(), SECONDARYSOURCESOVERRIDE_BINDING);
            protocolMarshaller.marshall(startBuildRequest.secondarySourcesVersionOverride(), SECONDARYSOURCESVERSIONOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.sourceVersion(), SOURCEVERSION_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.artifactsOverride(), ARTIFACTSOVERRIDE_BINDING);
            protocolMarshaller.marshall(startBuildRequest.secondaryArtifactsOverride(), SECONDARYARTIFACTSOVERRIDE_BINDING);
            protocolMarshaller.marshall(startBuildRequest.environmentVariablesOverride(), ENVIRONMENTVARIABLESOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.sourceTypeOverrideAsString(), SOURCETYPEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.sourceLocationOverride(), SOURCELOCATIONOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.sourceAuthOverride(), SOURCEAUTHOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.gitCloneDepthOverride(), GITCLONEDEPTHOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.buildspecOverride(), BUILDSPECOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.insecureSslOverride(), INSECURESSLOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.reportBuildStatusOverride(), REPORTBUILDSTATUSOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.environmentTypeOverrideAsString(), ENVIRONMENTTYPEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.imageOverride(), IMAGEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.computeTypeOverrideAsString(), COMPUTETYPEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.certificateOverride(), CERTIFICATEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.cacheOverride(), CACHEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.serviceRoleOverride(), SERVICEROLEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.privilegedModeOverride(), PRIVILEGEDMODEOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.timeoutInMinutesOverride(), TIMEOUTINMINUTESOVERRIDE_BINDING);
            protocolMarshaller.marshall((Object)startBuildRequest.idempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

