/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectSourceMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<Integer> GITCLONEDEPTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gitCloneDepth").isBinary(false).build();
    private static final MarshallingInfo<String> BUILDSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildspec").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AUTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("auth").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REPORTBUILDSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reportBuildStatus").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INSECURESSL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("insecureSsl").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceIdentifier").isBinary(false).build();
    private static final ProjectSourceMarshaller INSTANCE = new ProjectSourceMarshaller();

    private ProjectSourceMarshaller() {
    }

    public static ProjectSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectSource projectSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)projectSource, (String)"projectSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)projectSource.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)projectSource.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)projectSource.gitCloneDepth(), GITCLONEDEPTH_BINDING);
            protocolMarshaller.marshall((Object)projectSource.buildspec(), BUILDSPEC_BINDING);
            protocolMarshaller.marshall((Object)projectSource.auth(), AUTH_BINDING);
            protocolMarshaller.marshall((Object)projectSource.reportBuildStatus(), REPORTBUILDSTATUS_BINDING);
            protocolMarshaller.marshall((Object)projectSource.insecureSsl(), INSECURESSL_BINDING);
            protocolMarshaller.marshall((Object)projectSource.sourceIdentifier(), SOURCEIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

