/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.Project;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYSOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondarySources").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifacts").isBinary(false).build();
    private static final MarshallingInfo<List> SECONDARYARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondaryArtifacts").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cache").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceRole").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUTINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutInMinutes").isBinary(false).build();
    private static final MarshallingInfo<String> ENCRYPTIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionKey").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModified").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> WEBHOOK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("webhook").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BADGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("badge").isBinary(false).build();
    private static final ProjectMarshaller INSTANCE = new ProjectMarshaller();

    private ProjectMarshaller() {
    }

    public static ProjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Project project, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)project, (String)"project");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)project.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)project.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)project.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)project.source(), SOURCE_BINDING);
            protocolMarshaller.marshall(project.secondarySources(), SECONDARYSOURCES_BINDING);
            protocolMarshaller.marshall((Object)project.artifacts(), ARTIFACTS_BINDING);
            protocolMarshaller.marshall(project.secondaryArtifacts(), SECONDARYARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)project.cache(), CACHE_BINDING);
            protocolMarshaller.marshall((Object)project.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)project.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)project.timeoutInMinutes(), TIMEOUTINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)project.encryptionKey(), ENCRYPTIONKEY_BINDING);
            protocolMarshaller.marshall(project.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)project.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)project.lastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)project.webhook(), WEBHOOK_BINDING);
            protocolMarshaller.marshall((Object)project.vpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)project.badge(), BADGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

