/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectCacheMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final ProjectCacheMarshaller INSTANCE = new ProjectCacheMarshaller();

    private ProjectCacheMarshaller() {
    }

    public static ProjectCacheMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectCache projectCache, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)projectCache, (String)"projectCache");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)projectCache.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)projectCache.location(), LOCATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

