/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnvironmentLanguageMarshaller {
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").isBinary(false).build();
    private static final MarshallingInfo<List> IMAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("images").isBinary(false).build();
    private static final EnvironmentLanguageMarshaller INSTANCE = new EnvironmentLanguageMarshaller();

    private EnvironmentLanguageMarshaller() {
    }

    public static EnvironmentLanguageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnvironmentLanguage environmentLanguage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)environmentLanguage, (String)"environmentLanguage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)environmentLanguage.languageAsString(), LANGUAGE_BINDING);
            protocolMarshaller.marshall(environmentLanguage.images(), IMAGES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

